% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simplification.R
\name{simplify.mesh.2.5D}
\alias{simplify.mesh.2.5D}
\title{Perform the simplification of a mesh, given as an object of class \code{mesh.2.5D}.}
\usage{
simplify.mesh.2.5D(mesh,target,loc=NULL,val=NULL,wgeom=1/3,wdisp=1/3,wequi=1/3,file='')
}
\arguments{
\item{mesh}{A \code{mesh.2.5D} object, endowed with the following attributes:
\itemize{
    \item \code{nnodes}: number of nodes in the mesh;
    \item \code{nodes}: \code{nnodes}-by-3 matrix collecting the coordinates of each vertex;
    \item \code{ntriangles}: number of triangles in the mesh;
    \item \code{triangles}: a \code{ntriangles}-by-3 (when \code{order} = 1) or \code{ntriangles}-by-6 (when \code{order} = 2) matrix. It specifies the triangles giving the row indices in \code{nodes} of the triangles vertices and (when \code{order} = 2) also of the triangles edges midpoints;
    \item \code{order}: either '1' or '2'. It specifies whether each mesh triangle should be represented by \eqn{3} nodes (the triangle vertices) or by \eqn{6} nodes (the triangle vertices and midpoints of the triangle edges). These are respectively used for linear (\code{order} = 1) and quadratic (\code{order} = 2) Finite Elements. Default is \code{order} = 1.
}}

\item{target}{Number of nodes which the mesh should feature at the end of the simplification process. In other terms, \code{target} is used as stopping criterium: the algorithm stops when the number of nodes in the mesh matches \code{target}.}

\item{loc}{#data-by-3 vector with data locations; default is NULL, i.e. data locations are assumed to coincide with the mesh vertices.}

\item{val}{#data-by-1 vector with the observations associated with each data point; default is NULL.}

\item{wgeom}{Weight for the geometric component of the edge cost function; default is 1/3. Note that the all weights should be positive and sum up to one.}

\item{wdisp}{Weight for the data displacement component of the edge cost function; default is 1/3. Note that the all weights should be positive and sum up to one.}

\item{wequi}{Weight for the data equidistribution component of the edge cost function; default is 1/3. Note that the all weights should be positive and sum up to one.}

\item{file}{String specifying the path to the location where the simplified mesh will be stored; the following file formats are supported:
\itemize{
    \item AVS UCD ASCII (extension .inp);
    \item text files (extension .txt);
    \item Legacy VTK (extension .vtk).
}
Text files are assumed to be structured as the AVS UCD ASCII files (.inp extension).
If \code{outfile} is not provided, the mesh will not get saved to file but just returned as \code{mesh.2.5D} object.}
}
\value{
A list equipped with the following fields:
				\itemize{
					\item \code{mesh}: the simplified mesh as an instance of class \code{mesh.2.5D}; the order of the output mesh coincides with the order of the input mesh;
					\item \code{simplifier}: the object of class \code{RcppSimplification} used within the function to carry out the simplification procedure at the C++ level. This object is returned since eases (and speeds up) the extraction of useful information about the mesh, which are not directly made available by \code{mesh.2.5D} or which may rely on the connectivities of the mesh itself, as, e.g., the list of edges (see \code{\link{get.edges}});
					\item \code{locations}: #data-by-3 matrix holding the location of each data point over the simplified mesh;
						\item \code{qoi}: vector listing the quantity of information associated with each triangle in the simplified mesh; see \code{\link{get.quantity.of.information}} for a rigorous definition of the quantity of information.
				}
}
\description{
Implementation of a mesh simplification strategy for a surface mesh with associated distributed data. The algorithm works by iteratively collapsing an edge into an internal point. The selection of the edge to contract at each iteration is driven by a cost functional, which measures the loss of geometrical accuracy and data information associated with the collapse. For a detailed description of the algorithm, please refer to: \cr
				Dassi, F., Ettinger, B., Perotto, S., Sangalli, L.M. (2015), \cr
				A mesh simplification strategy for a spatial regression analysis over the  cortical surface of the brain, \cr
				Applied Numerical Mathematics, Vol. 90, pp. 111-131. \cr

				The whole (computing-intensive) procedure is carried out at the C++ level, thus ensuring high-performance. In detail, the function relies on the class \code{RcppSimplification} - a wrapper for the template class \code{simplification<Triangle, MeshType::DATA, DataGeo>} provided by the C++ library \code{meshsimplification}. Methods of class \code{RcppSimplification} are exposed to R through the API supplied by the \pkg{Rcpp} and \pkg{RcppEigen} packages.
}
\examples{
## Import the mesh of a pawn 
 data(pawn_250)
## Simplify the mesh down to 200 nodes; assume the components of the
## edge cost functions are equally weighted and that the data locations
## coincide with the vertices of the mesh
out1 <- simplify.mesh.2.5D(mesh, 200)
## Resume the simplification procedure, reducing the mesh down to 150 nodes
out2 <- simplify.mesh.2.5D(out1$mesh, 150, out1$locations)
}
\seealso{
\code{\link{plot.mesh.2.5D}}, \code{\link{import.mesh.2.5D}}
}
