% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/expand.R
\name{expand}
\alias{expand}
\title{Expand messy dates to lists of dates}
\usage{
expand(x, approx_range = 0)
}
\arguments{
\item{x}{A \code{mdate} object.
If not an 'mdate' object, conversion is handled first with ´as_messydate()´.}

\item{approx_range}{Range to expand approximate dates,
or date components, annotated with '~', by default 0.
That is, removes signs for approximate dates and
treats these dates as precise dates.
If 3, for example, adds 3 days for day approximation,
3 months for month approximation,
3 years for year/whole date approximation,
3 years and 3 months for year-month approximation,
and 3 months and 3 days for month-day approximation.}
}
\value{
A list of dates, including all dates in each range or set.
}
\description{
These functions expand on date ranges, sets of dates, and unspecified or
approximate dates (annotated with '..', '{ , }', 'XX' or '~').
As these messydates may refer to several possible dates,
the function "opens" these values to reveal a vector of all the possible
dates implied.
Imprecise dates (dates only containing information on year and/or month)
are also expanded to include possible dates within that year and/or month.
The function removes the annotation from dates with unreliable sources ('?'),
before being expanded normally as though they were incomplete.
}
\examples{
d <- as_messydate(c("2008-03-25", "-2012-02-27", "2001-01?", "~2001",
"2001-01-01..2001-02-02", "{2001-01-01,2001-02-02}", "{2001-01,2001-02-02}",
"2008-XX-31", "..2002-02-03", "2001-01-03..", "28 BC"))
expand(d)
}
