% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/coerce_to_messydate.R
\name{messydate}
\alias{messydate}
\alias{as_messydate}
\alias{as_messydate.Date}
\alias{as_messydate.POSIXct}
\alias{as_messydate.POSIXlt}
\alias{as_messydate.character}
\alias{as_messydate.list}
\alias{mdate}
\alias{make_messydate}
\title{Coercion from regular date classes to mdate}
\usage{
as_messydate(x, resequence = FALSE)

\method{as_messydate}{Date}(x, resequence = FALSE)

\method{as_messydate}{POSIXct}(x, resequence = FALSE)

\method{as_messydate}{POSIXlt}(x, resequence = FALSE)

\method{as_messydate}{character}(x, resequence = NULL)

\method{as_messydate}{list}(x, resequence = FALSE)

mdate(x, resequence = FALSE)

make_messydate(..., resequence = FALSE)
}
\arguments{
\item{x}{A scalar or vector of a class that can be coerced into \code{mdate},
such as \code{Date}, \code{POSIXct}, \code{POSIXlt}, or character.}

\item{resequence}{Users have the option to choose the order for
ambiguous dates with or without separators (e.g. "11-01-12" or "20112112").
\code{NULL} by default.
Other options include: 'dmy', 'ymd', 'mdy', 'ym', 'my' and 'interactive'
If 'dmy', dates are converted from DDMMYY format for 6 digit dates,
or DDMMYYYY format for 8 digit dates.
If 'ymd', dates are converted from YYMMDD format for 6 digit dates,
or YYYYMMDD format for 8 digit dates.
If 'mdy', dates are converted from MMDDYY format for 6 digit dates
or MMDDYYYY format for 8 digit dates.
For these three options, ambiguous dates are converted to YY-MM-DD format
for 6 digit dates, or YYYY-MM-DD format for 8 digit dates.
If 'my', ambiguous 6 digit dates are converted from MM-YYYY format
to YYYY-MM.
If 'ym', ambiguous 6 digit dates are converted to YYYY-MM format.
If 'interactive', it prompts users to select the existing
component order of ambiguous dates,
based on which the date is reordered into YYYY-MM-DD format
and further completed to YYYY-MM-DD format if they choose to do so.}

\item{...}{One (yyyy-mm-dd), two (yyyy-mm-dd, yyyy-mm-dd),
or three (yyyy, mm, dd) variables.}
}
\value{
A \code{mdate} class object
}
\description{
These methods coerce various date classes into the \code{mdate} class.
They represent the main user-facing class-creating functions in the package.
In addition to the typical date classes in R (\code{Date}, \code{POSIXct}, and \code{POSIXlt}),
there is also a direct method for converting text or character strings to \code{mdate}.
The function can also extract dates from text,
though this is a work-in-progress and currently only works in English.
}
\details{
If three date variables are passed to \code{make_messydate()},
function will create a single date (yyyy-mm-dd) from it.
If two date variables are passed to \code{make_messydate()},
function will create a range of dates from it (yyyy-mm-dd..yyyy-mm-dd).
If one date variable is passed to \code{make_messydate()},
function defaults to \code{as_messydate()}.
}
\section{Functions}{
\itemize{
\item \code{as_messydate()}: Core \code{mdate} class coercion function

\item \code{as_messydate(Date)}: Coerce from \code{Date} to \code{mdate} class

\item \code{as_messydate(POSIXct)}: Coerce from \code{POSIXct} to \code{mdate} class

\item \code{as_messydate(POSIXlt)}: Coerce from \code{POSIXlt} to \code{mdate} class

\item \code{as_messydate(character)}: Coerce character date objects to \code{mdate} class

\item \code{as_messydate(list)}: Coerce list date objects to the most concise
representation of \code{mdate} class

\item \code{make_messydate()}: Composes \code{mdate} from multiple variables

}}
\examples{
as_messydate("2021")
as_messydate("2021-02")
as_messydate("2021-02-01")
as_messydate("01-02-2021")
as_messydate("1 February 2021")
as_messydate("First of February, two thousand and twenty-one")
as_messydate("2021-02-01?")
as_messydate("2021-02-01~")
as_messydate("2021-02-01\%")
as_messydate("2021-02-01..2021-02-28")
as_messydate("{2021-02-01,2021-02-28}")
as_messydate(c("-2021", "2021 BC", "-2021-02-01"))
as_messydate(c("210201", "20210201"), resequence = "ymd")
as_messydate(c("010221", "01022021"), resequence = "dmy")
# as_messydate(c("01-02-21", "01-02-2021", "01-02-91", "01-02-1991"),
# resequence = "interactive")
as_messydate(list(c("2012-06-01", "2012-06-02", "2012-06-03")))
as_messydate(list(c("2012-06-01", "2012-06-02", "2012-06-03",
"{2012-06-01, 2012-06-02, 2012-06-03}", "2012-06-01", "2012-06-03")))
make_messydate("2010", "10", "10")
}
