% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/metainf.R
\name{metainf.meta}
\alias{metainf.meta}
\alias{metainf}
\alias{metainf.default}
\title{Influence analysis in meta-analysis using leave-one-out method}
\usage{
\method{metainf}{meta}(x, pooled, sortvar, no = 1, ...)

metainf(x, ...)

\method{metainf}{default}(x, ...)
}
\arguments{
\item{x}{An object of class \code{meta}.}

\item{pooled}{A character string indicating whether a common effect
or random effects model is used for pooling. Either missing (see
Details), \code{"common"} or \code{"random"}, can be abbreviated.}

\item{sortvar}{An optional vector used to sort the individual
studies (must be of same length as \code{x$TE}).}

\item{no}{A numeric specifying which meta-analysis results to
consider.}

\item{\dots}{Additional arguments (ignored).}
}
\value{
An object of class \code{"meta"} and \code{"metainf"} with
corresponding generic functions (see \code{\link{meta-object}}).

The following list elements have a different meaning:
\item{TE, seTE}{Estimated treatment effect and standard error of
  pooled estimate in influence analysis.}
\item{lower, upper}{Lower and upper confidence interval limits.}
\item{statistic}{Statistic for test of overall effect.}
\item{pval}{P-value for test of overall effect.}
\item{studlab}{Study label describing omission of studies.}
\item{w}{Sum of weights from common effect or random effects model.}
\item{TE.common, seTE.common}{Value is \code{NA}.}
\item{TE.random, seTE.random}{Value is \code{NA}.}
\item{Q}{Value is \code{NA}.}
}
\description{
Performs an influence analysis. Pooled estimates are calculated
omitting one study at a time.
}
\details{
Performs a influence analysis; pooled estimates are calculated
omitting one study at a time. Studies are sorted according to
\code{sortvar}.

Information from object \code{x} is utilised if argument
\code{pooled} is missing. A common effect model is assumed
(\code{pooled="common"}) if argument \code{x$common} is
\code{TRUE}; a random effects model is assumed
(\code{pooled="random"}) if argument \code{x$random} is
\code{TRUE} and \code{x$common} is \code{FALSE}.
}
\examples{
data(Fleiss1993bin)
m1 <- metabin(d.asp, n.asp, d.plac, n.plac,
  data = Fleiss1993bin, studlab = study, sm = "RR", method = "I")
m1
metainf(m1)
metainf(m1, pooled = "random")

forest(metainf(m1))
forest(metainf(m1), layout = "revman5")
forest(metainf(m1, pooled = "random"))

metainf(m1, sortvar = study)
metainf(m1, sortvar = 7:1)

m2 <- update(m1, title = "Fleiss1993bin meta-analysis", backtransf = FALSE)
metainf(m2)

data(Fleiss1993cont)
m3 <- metacont(n.psyc, mean.psyc, sd.psyc, n.cont, mean.cont, sd.cont,
  data = Fleiss1993cont, sm = "SMD")
metainf(m3)

}
\references{
Cooper H & Hedges LV (1994):
\emph{The Handbook of Research Synthesis}.
Newbury Park, CA: Russell Sage Foundation
}
\seealso{
\code{\link{metabin}}, \code{\link{metacont}},
  \code{\link{print.meta}}
}
\author{
Guido Schwarzer \email{guido.schwarzer@uniklinik-freiburg.de}
}
