% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/subset.pairwise.R
\name{subset.pairwise}
\alias{subset.pairwise}
\title{Return subset of pairwise object}
\usage{
\method{subset}{pairwise}(x, subset, ...)
}
\arguments{
\item{x}{An object of class \code{pairwise}.}

\item{subset}{A logical expression indicating rows to keep; missing values
are taken as false.}

\item{\dots}{Additional arguments.}
}
\value{
A pairwise object is returned.
}
\description{
The \code{subset} method returns a subset of a pairwise object.
}
\examples{
# Transform data from arm-based format to contrast-based format
p1 <- pairwise(list(Treatment1, Treatment2, Treatment3),
  n = list(n1, n2, n3),
  mean = list(y1, y2, y3), sd = list(sd1, sd2, sd3),
  data = dat.franchini2012, studlab = Study)
# Subset without Lieberman studies
subset(p1, !grepl("Lieberman", studlab))[, 1:5]

}
\seealso{
\code{\link{pairwise}}, \code{\link[metadat]{dat.franchini2012}}
}
\author{
Guido Schwarzer \email{guido.schwarzer@uniklinik-freiburg.de}
}
