% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/metabias.rm5.R
\name{metabias.rm5}
\alias{metabias.rm5}
\alias{metabias.cdir}
\title{Cochrane review: Test for funnel plot asymmetry}
\usage{
\method{metabias}{rm5}(
  x,
  comp.no,
  outcome.no,
  method.bias = "linreg",
  method.bias.binary = method.bias,
  method.bias.or = "score",
  k.min = 10,
  ...
)

\method{metabias}{cdir}(
  x,
  comp.no,
  outcome.no,
  method.bias = "linreg",
  method.bias.binary = method.bias,
  method.bias.or = "score",
  k.min = 10,
  ...
)
}
\arguments{
\item{x}{An object of class \code{rm5} or \code{cdir}.}

\item{comp.no}{Comparison number.}

\item{outcome.no}{Outcome number.}

\item{method.bias}{A character string indicating which test for
small-study effects is to be used for all outcomes. Either
\code{"rank"}, \code{"linreg"}, or \code{"mm"}, can be
abbreviated. See function \code{\link{metabias}}}

\item{method.bias.binary}{A character string indicating which test
is to be used for binary outcomes. Either \code{"rank"},
\code{"linreg"}, \code{"mm"}, \code{"count"}, \code{"score"}, or
\code{"peters"}, can be abbreviated. See function
\code{\link{metabias}}}

\item{method.bias.or}{A character string indicating which test is
to be used for binary outcomes with odds ratio as summary
measure. Either \code{"rank"}, \code{"linreg"}, \code{"mm"},
\code{"count"}, \code{"score"}, or \code{"peters"}, can be
abbreviated. See function \code{\link{metabias}}}

\item{k.min}{Minimum number of studies to perform test for
small-study effects.}

\item{...}{Additional arguments (ignored at the moment)}
}
\description{
Conduct a test for funnel plot asymmetry for all outcomes in a
Cochrane review of intervention studies
}
\details{
This function can be used to conduct a test for funnel plot
asymmetry for all or selected meta-analyses in a Cochrane review of
intervention studies (Higgins et al, 2023).

The R function \code{\link{metacr}} is called internally.
}
\examples{
# Locate export data file "Fleiss1993_CR.csv" in sub-directory of
# package "meta"
#
filename <- system.file("extdata", "Fleiss1993_CR.csv", package = "meta")
Fleiss1993_CR <- read.rm5(filename)

# Print results for all tests of small-study effects
#
metabias(Fleiss1993_CR, k.min = 5)

# Print result of test of small-study effects for second outcome in
# first comparison
#
metabias(Fleiss1993_CR, comp.no = 1, outcome.no = 2, k.min = 5)

}
\references{
Higgins JPT, Thomas J, Chandler J, Cumpston M, Li T, Page MJ, Welch
VA (editors) (2023):
\emph{Cochrane Handbook for Systematic Reviews of Interventions
  Version 6.4 (updated August 2023)}.
Available from \url{https://training.cochrane.org/handbook/}
}
\seealso{
\code{\link{metabias}}, \code{\link{metacr}},
  \code{\link{read.rm5}}, \code{\link{read.cdir}},
  \code{\link{summary.rm5}}, \code{\link{summary.cdir}}
}
\author{
Guido Schwarzer \email{guido.schwarzer@uniklinik-freiburg.de}
}
\keyword{htest}
