% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/es_from_PAIRED_STATISTICS.R
\name{es_from_paired_t_pval}
\alias{es_from_paired_t_pval}
\title{Convert two paired t-test p-value obtained from two independent groups into several effect size measures}
\usage{
es_from_paired_t_pval(
  paired_t_pval_exp,
  paired_t_pval_nexp,
  n_exp,
  n_nexp,
  r_pre_post_exp,
  r_pre_post_nexp,
  smd_to_cor = "viechtbauer",
  reverse_paired_t_pval
)
}
\arguments{
\item{paired_t_pval_exp}{P-value of the paired t-test value of the experimental/exposed group.}

\item{paired_t_pval_nexp}{P-value of the paired t-test value of the non-experimental/non-exposed group.}

\item{n_exp}{number of participants in the experimental/exposed group.}

\item{n_nexp}{number of participants in the non-experimental/non-exposed group.}

\item{r_pre_post_exp}{pre-post correlation in the experimental/exposed group}

\item{r_pre_post_nexp}{pre-post correlation in the non-experimental/non-exposed group}

\item{smd_to_cor}{formula used to convert the \code{cohen_d} value into a coefficient correlation (see details).}

\item{reverse_paired_t_pval}{a logical value indicating whether the direction of generated effect sizes should be flipped.}
}
\value{
This function estimates and converts between several effect size measures.

\tabular{ll}{
\code{natural effect size measure} \tab D + G\cr
\tab \cr
\code{converted effect size measure} \tab OR + R + Z \cr
\tab \cr
\code{required input data} \tab See 'Section 16. Paired: Paired F- or t-test'\cr
\tab https://metaconvert.org/html/input.html\cr
\tab \cr
}
}
\description{
Convert two paired t-test p-value obtained from two independent groups into several effect size measures
}
\details{
This function converts the p-values of two paired t-test obtained from two independent groups value into a Cohen's d (D) and Hedges' g (G) (table 12.2 in Cooper).
Odds ratio (OR) and correlation coefficients (R/Z) are then converted from the Cohen's d.

\strong{To estimate the Cohen's d,} the following formulas are used (Cooper et al., 2019):
This function converts a Student's t-test value into a Cohen's d (table 12.2 in Cooper).
\deqn{paired\_t\_exp = qt(\frac{paired\_t\_pval\_exp}{2}, df = n\_exp - 1) * \sqrt{\frac{2 * (1 - r\_pre\_post\_exp)}{n\_exp}}}
\deqn{paired\_t\_nexp = qt(\frac{paired\_t\_pval\_nexp}{2}, df = n\_nexp - 1) * \sqrt{\frac{2 * (1 - r\_pre\_post\_nexp)}{n\_nexp}}}

\strong{To estimate other effect size measures},
calculations of the \code{\link{es_from_cohen_d}()} are applied.
}
\examples{
es_from_paired_t_pval(paired_t_pval_exp = 0.4, paired_t_pval_nexp = 0.01, n_exp = 19, n_nexp = 22)
}
\references{
Cooper, H., Hedges, L.V., & Valentine, J.C. (Eds.). (2019). The handbook of research synthesis and meta-analysis. Russell Sage Foundation.
}
