% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/es_variability_from_dispersion.R
\name{es_variab_from_means_ci}
\alias{es_variab_from_means_ci}
\title{Title}
\usage{
es_variab_from_means_ci(
  mean_exp,
  mean_nexp,
  mean_ci_lo_exp,
  mean_ci_up_exp,
  mean_ci_lo_nexp,
  mean_ci_up_nexp,
  n_exp,
  n_nexp,
  reverse_means_variability
)
}
\arguments{
\item{mean_exp}{mean of participants in the experimental/exposed group.}

\item{mean_nexp}{mean of participants in the non-experimental/non-exposed group.}

\item{mean_ci_lo_exp}{lower bound of the 95\% CI of the mean of the experimental/exposed group}

\item{mean_ci_up_exp}{upper bound of the 95\% CI of the mean of the experimental/exposed group}

\item{mean_ci_lo_nexp}{lower bound of the 95\% CI of the mean of the non-experimental/non-exposed group.}

\item{mean_ci_up_nexp}{upper bound of the 95\% CI of the mean of the non-experimental/non-exposed group.}

\item{n_exp}{number of participants in the experimental/exposed group.}

\item{n_nexp}{number of participants in the non-experimental/non-exposed group.}

\item{reverse_means_variability}{a logical value indicating whether the direction of the generated effect sizes should be flipped.}
}
\value{
This function estimates VR and CVR

\tabular{ll}{
\code{natural effect size measure} \tab VR + CVR\cr
\tab \cr
\code{converted effect size measure} \tab No conversion performed\cr
\tab \cr
\code{required input data} \tab See 'Section 23. User's input (crude)'\cr
\tab https://metaconvert.org/html/input.html\cr
\tab \cr
}
}
\description{
Title
}
\details{
This function converts the bounds of the 95\% CI of the means of two independent groups into standard errors.
\deqn{mean\_se\_exp = \frac{mean\_ci\_up\_exp - mean\_ci\_lo\_exp}{2 * qt{(0.975, df = n\_exp - 1)}}}
\deqn{mean\_se\_nexp = \frac{mean\_ci\_up\_nexp - mean\_ci\_lo\_nexp}{2 * qt{(0.975, df = n\_nexp - 1)}}}

Then, calculations of the \code{\link{es_variab_from_means_se}} are applied.
}
\examples{
es_variab_from_means_ci(
  mean_exp = 42, mean_ci_lo_exp = 32, mean_ci_up_exp = 52,
  mean_nexp = 42, mean_ci_lo_nexp = 37, mean_ci_up_nexp = 47,
  n_exp = 43, n_nexp = 34
)
}
\references{
Senior, A. M., Viechtbauer, W., & Nakagawa, S. (2020). Revisiting and expanding the meta-analysis of variation: The log coefficient of variation ratio. Research Synthesis Methods, 11(4), 553-567. https://doi.org/10.1002/jrsm.1423
}
