% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/es_from_PAIRED_MEANS.R
\name{es_from_means_ci_pre_post}
\alias{es_from_means_ci_pre_post}
\title{Convert pre-post means of two independent groups into various effect size measures}
\usage{
es_from_means_ci_pre_post(
  mean_pre_exp,
  mean_exp,
  mean_pre_ci_lo_exp,
  mean_pre_ci_up_exp,
  mean_ci_lo_exp,
  mean_ci_up_exp,
  mean_pre_nexp,
  mean_nexp,
  mean_pre_ci_lo_nexp,
  mean_pre_ci_up_nexp,
  mean_ci_lo_nexp,
  mean_ci_up_nexp,
  n_exp,
  n_nexp,
  r_pre_post_exp,
  r_pre_post_nexp,
  smd_to_cor = "viechtbauer",
  pre_post_to_smd = "bonett",
  max_asymmetry = 10,
  reverse_means_pre_post
)
}
\arguments{
\item{mean_pre_exp}{mean of the experimental/exposed group at baseline}

\item{mean_exp}{mean of the experimental/exposed group at follow up}

\item{mean_pre_ci_lo_exp}{lower bound of the 95\% CI of the mean of the experimental/exposed group at baseline}

\item{mean_pre_ci_up_exp}{upper bound of the 95\% CI of the mean of the experimental/exposed group at baseline}

\item{mean_ci_lo_exp}{lower bound of the 95\% CI of the mean of the experimental/exposed group at follow up}

\item{mean_ci_up_exp}{upper bound of the 95\% CI of the mean of the experimental/exposed group at follow up}

\item{mean_pre_nexp}{mean of the non-experimental/non-exposed group at baseline}

\item{mean_nexp}{mean of the non-experimental/non-exposed group at follow up}

\item{mean_pre_ci_lo_nexp}{lower bound of the 95\% CI of the mean of the non-experimental/non-exposed group at baseline}

\item{mean_pre_ci_up_nexp}{upper bound of the 95\% CI of the mean of the non-experimental/non-exposed group at baseline}

\item{mean_ci_lo_nexp}{lower bound of the 95\% CI of the mean of the non-experimental/non-exposed group at follow up}

\item{mean_ci_up_nexp}{upper bound of the 95\% CI of the mean of the non-experimental/non-exposed group at follow up}

\item{n_exp}{number of the experimental/exposed group}

\item{n_nexp}{number of the non-experimental/non-exposed group}

\item{r_pre_post_exp}{pre-post correlation in the experimental/exposed group}

\item{r_pre_post_nexp}{pre-post correlation in the non-experimental/non-exposed group}

\item{smd_to_cor}{formula used to convert the \code{cohen_d} value into a coefficient correlation (see details).}

\item{pre_post_to_smd}{formula used to convert the pre and post means/SD into a SMD (see details).}

\item{max_asymmetry}{A percentage indicating the tolerance before detecting asymmetry in the 95\% CI bounds.}

\item{reverse_means_pre_post}{a logical value indicating whether the direction of generated effect sizes should be flipped.}
}
\value{
This function estimates and converts between several effect size measures.

\tabular{ll}{
\code{natural effect size measure} \tab MD + D + G\cr
\tab \cr
\code{converted effect size measure} \tab OR + R + Z \cr
\tab \cr
\code{required input data} \tab See 'Section 15. Paired: pre-post means and dispersion'\cr
\tab https://metaconvert.org/input.html\cr
\tab \cr
}
}
\description{
Convert pre-post means of two independent groups into various effect size measures
}
\details{
This function converts the bounds of the 95\% CI of the pre/post means of two independent groups into standard errors (Section 6.3.1 in the Cochrane Handbook).
\deqn{mean\_pre\_se\_exp = \frac{mean\_pre\_ci\_up\_exp - mean\_pre\_ci\_lo\_exp}{2 * qt{(0.975, df = n\_exp - 1)}}}
\deqn{mean\_pre\_se\_nexp = \frac{mean\_pre\_ci\_up\_nexp - mean\_pre\_ci\_lo\_nexp}{2 * qt{(0.975, df = n\_nexp - 1)}}}
\deqn{mean\_se\_exp = \frac{mean\_ci\_up\_exp - mean\_ci\_lo\_exp}{2 * qt{(0.975, df = n\_exp - 1)}}}
\deqn{mean\_se\_nexp = \frac{mean\_ci\_up\_nexp - mean\_ci\_lo\_nexp}{2 * qt{(0.975, df = n\_nexp - 1)}}}

Then, calculations of the \code{\link{es_from_means_se_pre_post}} are applied.
}
\examples{
es_from_means_ci_pre_post(
  n_exp = 36, n_nexp = 35,
  mean_pre_exp = 98,
  mean_pre_ci_lo_exp = 88,
  mean_pre_ci_up_exp = 108,
  mean_exp = 102,
  mean_ci_lo_exp = 92,
  mean_ci_up_exp = 112,
  mean_pre_nexp = 96,
  mean_pre_ci_lo_nexp = 86,
  mean_pre_ci_up_nexp = 106,
  mean_nexp = 102,
  mean_ci_lo_nexp = 92,
  mean_ci_up_nexp = 112,
  r_pre_post_exp = 0.8, r_pre_post_nexp = 0.8
)
}
\references{
Higgins JPT, Li T, Deeks JJ (editors). Chapter 6: Choosing effect size measures and computing estimates of effect. In: Higgins JPT, Thomas J, Chandler J, Cumpston M, Li T, Page MJ, Welch VA (editors). Cochrane Handbook for Systematic Reviews of Interventions version 6.3 (updated February 2022). Cochrane, 2022. Available from www.training.cochrane.org/handbook.
}
