\name{metaSEM-package}
\alias{metaSEM-package}
\alias{metaSEM}
\docType{package}
\title{Meta-Analysis using Structural Equation Modeling
}
\description{A collection of functions for conducting meta-analysis using a
             structural equation modeling (SEM) approach via the 'OpenMx' and
             'lavaan' packages. It also implements various procedures to
			 perform meta-analytic structural equation modeling on the
             correlation and covariance matrices.
}
\details{
\tabular{ll}{
Package: \tab metaSEM\cr
Type: \tab Package\cr
Version: \tab 1.3.0\cr
Date: \tab 2023-01-07\cr
License: \tab GPL (>=2)\cr
LazyLoad: \tab yes\cr
}
}
\author{Mike W.-L. Cheung <mikewlcheung@nus.edu.sg>

Maintainer: Mike W.-L. Cheung <mikewlcheung@nus.edu.sg>
}
\references{
Cheung, M. W.-L. (2008). A model for integrating fixed-, random-, and
mixed-effects meta-analyses into structural equation
modeling. \emph{Psychological Methods}, \bold{13} (3),
182-202. https://doi.org/10.1037/a0013163

Cheung, M. W.-L. (2009). Constructing approximate confidence intervals
for parameters with structural equation models. \emph{Structural
  Equation Modeling}, \bold{16} (2),
267-294. https://doi.org/10.1080/10705510902751291

Cheung, M. W.-L. (2010). Fixed-effects meta-analyses as multiple-group
structural equation models. \emph{Structural Equation Modeling},
\bold{17} (3), 481-509. https://doi.org/10.1080/10705511.2010.489367

Cheung, M. W.-L. (2013). Implementing restricted maximum likelihood
estimation in structural equation models. \emph{Structural Equation
  Modeling}, \bold{20} (1), 157-167. https://doi.org/10.1080/10705511.2013.742404

Cheung, M. W.-L. (2013). Multivariate meta-analysis as structural
equation models. \emph{Structural Equation Modeling}, \bold{20} (3),
429-454. https://doi.org/10.1080/10705511.2013.797827

Cheung, M. W.-L. (2014). Modeling dependent effect sizes with
three-level meta-analyses: A structural equation modeling
approach. \emph{Psychological Methods}, \bold{19} (2),
211-229. https://doi.org/10.1037/a0032968

Cheung, M. W.-L. (2014). Fixed- and random-effects meta-analytic
structural equation modeling: Examples and analyses in R. \emph{Behavior
  Research Methods}, \bold{46} (1),
29-40. https://doi.org/10.3758/s13428-013-0361-y

Cheung, M. W.-L. (2015). metaSEM: An R package for meta-analysis using
structural equation modeling. \emph{Frontiers in Psychology}, \bold{5}
(1521). https://doi.org/10.3389/fpsyg.2014.01521

Cheung, M. W.-L. (2015). \emph{Meta-Analysis: A Structural Equation
  Modeling Approach}. Chichester, West Sussex: John Wiley & Sons, Inc.

Cheung, M. W.-L. (2018). Issues in solving the problem of effect size
heterogeneity in meta-analytic structural equation modeling: A
commentary and simulation study on Yu, Downes, Carter, and O'Boyle
(2016). \emph{Journal of Applied Psychology}, \bold{103} (7),
787-803. https://doi.org/10.1037/apl0000284

Cheung, M. W.-L. (2018). Computing multivariate effect sizes and their
sampling covariance matrices with structural equation modeling: Theory,
examples, and computer simulations. \emph{Frontiers in Psychology},
\bold{9} (1387). https://doi.org/10.3389/fpsyg.2018.01387

Cheung, M. W.-L. (2019). Some reflections on combining meta-analysis and
structural equation modeling. \emph{Research Synthesis Methods},
\bold{10} (1), 15-22. https://doi.org/10.1002/jrsm.1321

Cheung, M. W.-L. (2021). Meta-analytic structural equation modeling. In
\emph{Oxford Research Encyclopedia of Business and Management}. Oxford
University Press. https://doi.org/10.1093/acrefore/9780190224851.013.225

Cheung, M. W.-L., & Chan, W. (2004). Testing dependent correlation
coefficients via structural equation modeling. \emph{Organizational
  Research Methods}, \bold{7} (2),
206-223. https://doi.org/10.1177/1094428104264024

Cheung, M. W.-L., & Chan, W. (2005). Meta-analytic structural equation
modeling: A two-stage approach. \emph{Psychological Methods}, \bold{10}
(1), 40-64. https://doi.org/10.1037/1082-989X.10.1.40

Cheung, M. W.-L., & Chan, W. (2009). A two-stage approach to
synthesizing covariance matrices in meta-analytic structural equation
modeling. \emph{Structural Equation Modeling}, \bold{16} (1),
28-53. https://doi.org/10.1080/10705510802561295 

Cheung, M. W.-L., & Cheung, S.-F. (2016). Random-effects models for
meta-analytic structural equation modeling: Review, issues, and
illustrations. \emph{Research Synthesis Methods}, \bold{7} (2),
140-155. https://doi.org/10.1002/jrsm.1166

Jak, S., & Cheung, M. W.-L. (2018). Testing moderator hypotheses in
meta-analytic structural equation modeling using subgroup
analysis. \emph{Behavior Research Methods}, \bold{50} (4),
1359-1373. https://doi.org/10.3758/s13428-018-1046-3

Jak, S., & Cheung, M. W.-L. (2020). Meta-analytic structural equation
modeling with moderating effects on SEM parameters. \emph{Psychological
  Methods}, \bold{25} (4), 430-455. https://doi.org/10.1037/met0000245
}
\keyword{ package }


