% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rescue.R
\name{diagnosticTolerance}
\alias{diagnosticTolerance}
\title{Compute appropriate tolerance for the given model}
\usage{
diagnosticTolerance(model, mc.cores = 2, solver = SYBIL_SETTINGS("SOLVER"),
  method = SYBIL_SETTINGS("METHOD"))
}
\arguments{
\item{model}{An object of class \code{modelorg}.}

\item{mc.cores}{The number of cores to use (at least 2), i.e. at most how many child processes will be run simultaneously. Default: 2.}

\item{solver}{A character indicating the solver to be used in \code{\link{sybil}}. Default: \code{SYBIL_SETTINGS("SOLVER")}.}

\item{method}{A character indicating the method to be used in \code{\link{sybil}}. Default: \code{SYBIL_SETTINGS("METHOD")}.}
}
\value{
Tolerance
}
\description{
The function computes a tolerance value which is appropriate to a model. This is an empirical procedure whose results must be considered with caution.
}
\keyword{internal}
