% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/02Metaheur.R
\name{metaheur}
\alias{metaheur}
\title{metaheuristic optimization of preprocessing combinations}
\usage{
metaheur(gridclassobject, startgrid = 0, startnum = 1, iterations = 10,
  taboolistlength = 1, initialtemperature = 0.01, tempconst = 0.01,
  reheat = 0.01, nholdout = 2, late = 0, stopcond = 1,
  stopvalue = 0.99, deltafive = 0.05, model = "rpart", cores = 1)
}
\arguments{
\item{gridclassobject}{(GridClass) created by setgrid function in preprocomb package}

\item{startgrid}{(integer) 0 random restart (default), 1 grid restart}

\item{startnum}{(integer) number of restarts}

\item{iterations}{(integer) number of iterations done for a restart, defaults to 10}

\item{taboolistlength}{(integer) number of previous solution that can not be revisited, must be 1 or more}

\item{initialtemperature}{(numeric) initial propability for acccepting an inferior candidate, between 0 and 1}

\item{tempconst}{(numeric) multiplier for decreasing temperature on each iteration}

\item{reheat}{(numeric) propability of increasing temperature on each iteration}

\item{nholdout}{(integer) number of holdout rounds, defaults to 2}

\item{late}{(integer) location of previous best solution a candidate is compared to, defaults to 0 for last}

\item{stopcond}{(integer) type of stopping condition in addition to iterations, default to 1 for threshold, 2 for convergence}

\item{stopvalue}{(numeric) threshold for stopping, defaults to 0.99}

\item{deltafive}{(numeric) convergence criteria for last five iterations, defaults to 0.05}

\item{model}{(character) caret name of predictive model, defaults to "rpart"}

\item{cores}{(integer) number of cores used in computation of classification accuracy holdout rounds, defaults to 1}
}
\description{
metaheuristic optimization of preprocessing combinations
}
\examples{
## result <- metaheur(examplegrid, startnum=2, nholdout=2, cores=2)
## getbestheur(result)
}

