% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/format_ae_exp_adj.R
\name{format_ae_exp_adj}
\alias{format_ae_exp_adj}
\title{Format exposure-adjusted AE summary}
\usage{
format_ae_exp_adj(
  outdata,
  display = c("n", "total_exp", "events", "eaer", "total"),
  digits_total_exp = 2,
  digits_eaer = 2,
  mock = FALSE
)
}
\arguments{
\item{outdata}{An \code{outdata} object created by \code{\link[=prepare_ae_specific]{prepare_ae_specific()}}.}

\item{display}{A character vector of measurement to be displayed:
\itemize{
\item \code{n}: Number of subjects exposed.
\item \code{total_exp}: Total exposure in person-time.
\item \code{events}: Number of AE.
\item \code{eaer}: Exposure adjusted event rate.
\item \code{total}: Total columns.
}}

\item{digits_total_exp}{A numeric value of number of digits for total exposure value.}

\item{digits_eaer}{A numeric value of number of digits for exposure-adjusted event rate.}

\item{mock}{A boolean value to display mock table.}
}
\value{
A list of analysis raw datasets.
}
\description{
Format exposure-adjusted AE summary
}
\examples{
meta <- meta_ae_example()

outdata <- meta |>
  prepare_ae_summary(
    population = "apat",
    observation = "wk12",
    parameter = "any;ser;rel"
  ) |>
  extend_ae_summary_eaer(adj_unit = "month")
tbl <- outdata |>
  format_ae_exp_adj()
head(tbl$tbl)
}
