% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/collect_n_subject.R
\name{collect_n_subject}
\alias{collect_n_subject}
\title{Collect number of subjects and its subset condition}
\usage{
collect_n_subject(
  meta,
  population,
  parameter,
  listing = FALSE,
  histogram = FALSE,
  var_listing = NULL,
  remove_blank_group = FALSE,
  type = "Subjects",
  use_na = c("ifany", "no", "always"),
  display_total = TRUE
)
}
\arguments{
\item{meta}{A \code{meta_adam} object.}

\item{population}{A character value of population term name.
The term name is used as key to link information.}

\item{parameter}{A character value of parameter term name.
The term name is used as key to link information.}

\item{listing}{A logical value to display drill down listing per row.}

\item{histogram}{A logical value to display histogram by group.}

\item{var_listing}{A character vector of additional variables included
in the listing.}

\item{remove_blank_group}{A logical value to remove a group with all
missing value of a parameter.}

\item{type}{A character value to control title name,
e.g., Subjects or Records.}

\item{use_na}{A character value for whether to include \code{NA} values
in the table. See the \code{useNA} argument in \code{\link[base:table]{base::table()}} for more details.}

\item{display_total}{A logical value to display total column.}
}
\value{
A list containing number of subjects and its subset condition.
}
\description{
Collect number of subjects and its subset condition
}
\examples{
suppressWarnings(
  meta <- meta_example() |>
    define_parameter(name = "sex", var = "SEX", label = "Sex")
)
collect_n_subject(meta, "apat", "sex")
}
