% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/metamedian.R
\name{metamedian}
\alias{metamedian}
\title{Meta-Analysis of the (difference of) medians}
\usage{
metamedian(
  data,
  median_method = "qe",
  single.family = FALSE,
  loc.shift = FALSE,
  norm.approx = TRUE,
  coverage.prob = 0.95,
  cd_method = "RE",
  pool_studies = TRUE,
  ...
)
}
\arguments{
\item{data}{data frame containing the study-specific summary data. For one-group studies, this data frame can contain the following columns:
\tabular{ll}{
\code{min.g1} \tab minimum value. \cr
\code{q1.g1} \tab first quartile. \cr
\code{med.g1} \tab median. \cr
\code{q3.g1} \tab third quartile. \cr
\code{max.g1} \tab maximum value. \cr
\code{n.g1} \tab sample size. \cr
\code{mean.g1} \tab sample mean. \cr
\code{sd.g1} \tab sample standard deviation. \cr
\code{med.var.g1} \tab sampling variance of the median (only applicable when \code{median_method="cd"}). \cr
\code{med.ci.lb.g1} \tab lower confidence interval bound around the median (only applicable when \code{median_method="cd"}). \cr
\code{med.ci.ub.g1} \tab upper confidence interval bound around the median (only applicable when \code{median_method="cd"}). \cr
\code{alpha.1.g1} \tab \eqn{\alpha_1} values from Ozturk and Balakrishnan (2020) (only applicable when \code{median_method="cd"}). \cr
\code{alpha.2.g1} \tab \eqn{\alpha_2} values from Ozturk and Balakrishnan (2020) (only applicable when \code{median_method="cd"}). \cr}
For two group studies, this data frame can also contain the following columns for the summary data of the second group: \code{min.g2}, \code{q1.g2}, \code{med.g2}, \code{q3.g2}, \code{max.g2}, \code{n.g2}, \code{mean.g2}, and \code{sd.g2}.}

\item{median_method}{character string specifying the approach used to estimate the study-specific means and their standard errors. The options are
\tabular{ll}{
\code{"mm"} \tab Median of Medians (McGrath et al. 2019) for one-group studies and Median of the Difference of Medians (McGrath et al. 2020) for two group studies. \cr
\code{"wm"} \tab Weighted Median of Medians (McGrath et al. 2019) for one-group studies and Weighted Median of the Difference of Medians (McGrath et al. 2020) for two group studies. \cr
\code{"qe"} \tab Quantile Matching Estimation (McGrath et al. 2020). This approach is applicable for one-group studies or two-group studies. This is the default option. \cr
\code{"cd"} \tab Confidence Distribution (Ozturk and Balakrishnan 2020). This approach is applicable for one-group studies. \cr}}

\item{single.family}{(only applicable when \code{median_method} is set to \code{"qe"}) logical scalar indicating that for two-group studies, the parametric family of distributions is assumed to be the same across both groups. The default is \code{FALSE}. See 'Details' of \code{\link{qe.study.level}}.}

\item{loc.shift}{(only applicable when \code{median_method} is set to \code{"qe"}) logical scalar indicating that for two-group studies, distributions are assumed to only differ by a location shift. The default is \code{FALSE}. See 'Details' of \code{\link{qe.study.level}}.}

\item{norm.approx}{(only applicable when \code{median_method} is set to \code{"mm"} or \code{"wm"}) logical scalar indicating whether normality approximation of the binomial should be used to construct an approximate confidence interval. The default is \code{TRUE}.}

\item{coverage.prob}{(only applicable when \code{median_method} is set to \code{"mm"}, \code{"wm"}, or \code{"cd"}) numeric scalar indicating the desired coverage probability for the pooled (difference of medians) estimate. The default is \code{0.95}.}

\item{cd_method}{(only applicable when \code{median_method} is set to \code{"cd"}) character string specifying whether a fixed effect or random effects model is used. The options are \code{FE} (fixed effect) are \code{RE} (random effects). The default is \code{RE}.}

\item{pool_studies}{logical scalar specifying whether to meta-analyze the studies. If this argument is set to \code{FALSE}, function will not meta-analyze the studies and will return a list with components \code{yi} containing the study-specific outcome measure estimates and \code{sei} containing the study-specific within-study standard error estimates. The default is \code{TRUE}.}

\item{...}{(only applicable when \code{median_method} is set to \code{"qe"}) optional arguments that are passed into the \code{\link[metafor]{rma.uni}} function for pooling. See documentation of \code{\link[metafor]{rma.uni}}.}
}
\value{
an object of class "rma.uni" (when \code{median_method} is set to \code{"qe"}) or a list (when \code{median_method} is set to \code{"mm"}, \code{"wm"}, or \code{"cd"}). For additional details, see \code{\link[metafor]{rma.uni}} (when \code{median_method} is set to \code{"qe"}), \code{\link{pool.med}} (when \code{median_method} is set to \code{"mm"} or \code{"wm"}), and \code{\link{cd}} (when \code{median_method} is set to \code{"cd"}).
}
\description{
This function is a wrapper function for the \code{\link{qe}}, \code{\link{cd}}, and \code{\link{pool.med}} functions. The function implements the methods of McGrath et al. (2019), McGrath et al. (2020), and Ozturk and Balakrishnan (2020) to estimate the pooled (difference of) medians in a meta-analysis. Specifically, the function implements the (weighted) median of medians method, the Ozturk and Balakrishnan (2020) method, and the quantile matching estimation method to meta-analyze one-group studies; the function implements the (weighted) median of the difference of medians method and quantile matching estimation method to meta-analyze two-group studies.
}
\examples{
## Quantile Matching Estimation method
metamedian(data = dat.age, median_method = "qe")

## Median of the Difference of Medians method
metamedian(data = dat.age, median_method = "mm")

## Weighted Median of the Difference of Medians method
metamedian(data = dat.age, median_method = "wm")

}
\references{
McGrath S., Zhao X., Qin Z.Z., Steele R., and Benedetti A. (2019). One-sample aggregate data meta-analysis of medians. \emph{Statistics in Medicine}, \strong{38}, 969-984.

McGrath S., Sohn H., Steele R., and Benedetti A. (2020). Meta-analysis of the difference of medians. \emph{Biometrical Journal}, \strong{62}, 69-98.

McGrath S., Zhao X., Ozturk O., Katzenschlager S., Steele R., and Benedetti A. (in press). metamedian: An R package for meta-analyzing studies reporting medians. \emph{Research Synthesis Methods}.

Ozturk O. and Balakrishnan N. (2020). Meta‐analysis of quantile intervals from different studies with an application to a pulmonary tuberculosis data. \emph{Statistics in Medicine}, \strong{39}, 4519-4537.
}
