% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/meta.niceplot.R
\name{meta.niceplot}
\alias{meta.niceplot}
\title{Nice meta-analysis plots.}
\usage{
meta.niceplot(metadat, sumtype = "taxa", level = "main", p, p.adjust,
  phyla.col = "rainbow", phyla.select = c("actinobacteria",
  "bacteroidetes", "cyanobacteria", "firmicutes", "fusobacteria",
  "proteobacteria", "verrucomicrobia", ".thermi."),
  col.select = c("#dd1c77", "#31a354", "#91003f", "#d95f0e", "#636363",
  "#2ef0e7", "#862ef0", "#000"), est.break = c(-Inf, -1, -0.5, -0.1, 0,
  0.1, 0.5, 1, Inf), est.break.label = c("<-1", "[-1,-0.5)",
  "[-0.5,-0.1)", "[-0.1,0)", "[0,0.1)", "[0.1,0.5)", "[0.5,1)", ">=1"),
  neg.palette = "PuBu", pos.palette = "YlOrRd", p.sig.heat = "no",
  p.break = c(0, 1e-04, 0.05, 1), p.break.label = c("**", "*", ""),
  p.pool.break = c(0, 0.05, 1), p.pool.break.label = c("[0,0.05)",
  "[0.05,1]"), padjust.pool.break = c(0, 0.1, 1),
  padjust.pool.break.label = c("[0,0.1)", "[0.1,1]"),
  forest.est.shape = c("17", "16"), forest.est.col = c("red", "black"),
  forest.col = "by.pvalue", leg.key.size = 1, leg.text.size = 8,
  heat.text.x.size = 8, heat.text.x.angle = 0,
  forest.axis.text.y = 8, forest.axis.text.x = 8,
  heat.forest.width.ratio = c(1, 1), point.ratio = c(3, 1),
  line.ratio = c(2, 1))
}
\arguments{
\item{metadat}{output data from metatab.show.}

\item{sumtype}{Either "taxa" for taxa and "path" for pathway.}

\item{level}{"main" for main level such as phylum or "sub" for higher level such as species. Default is "main".}

\item{p}{name of variable for p-values}

\item{p.adjust}{name of variable for multiple testing adjusted p-values}

\item{phyla.col}{type of color for main level (phylum). Options are "rainbow" (default) or "select".}

\item{phyla.select}{selected phyla for selected colors (only when phyla.col="select"). Default are c("actinobacteria","bacteroidetes","cyanobacteria","firmicutes","fusobacteria","proteobacteria","verrucomicrobia",".thermi.").}

\item{col.select}{selected colors for selected phyla (only when phyla.col="select"). Corresponding default are c("#dd1c77","#31a354","#91003f","#d95f0e","#636363","#2ef0e7","#862ef0","#000").}

\item{est.break}{breaks for estimates to generate color categories on heatmap. Default are c(-Inf, -1,-0.5,-0.1,0,0.1,0.5,1, Inf). For pathway, recommended breaks are c(-Inf, -0.5,-0.1,-0.05,0,0.05,0.1,0.5, Inf).}

\item{est.break.label}{labels for corresponding color categories on heatmap generated by est.break. Default corresponding to default est.break are c("<-1","[-1,-0.5)","[-0.5,-0.1)","[-0.1,0)", "[0,0.1)", "[01,0.5)", "[0.5,1)", ">=1"). For pathway, corresponding recommended labels are c("<-0.5)", "[-0.5,-0.1)","[-0.1,-0.05)","[-0.05,0)","[0,0.05)","[0.05,0.1)", "[0.1,0.5)", ">=0.5").}

\item{neg.palette}{color palette for negative estimate values. Default is "PuBu". Use display.brewer.all() of RColorBrewer package for other options.}

\item{pos.palette}{color palette for positive estimate values. Default is "YlOrRd". Use display.brewer.all() of RColorBrewer package for other options.}

\item{p.sig.heat}{whether or not show significant p values on heatmap. Default is "yes".}

\item{p.break}{breaks for significant levels of p values. Default is c(0, 0.0001,0.05, 1).}

\item{p.break.label}{labels to be showed on heatmap for different levels of p-values from p.break. Default is c("**", "*","") for p breaks at c(0, 0.0001,0.05, 1).}

\item{p.pool.break}{breaks for pooled p-values to be distinguished in forest plot. Default are c(0,0.05,1).}

\item{p.pool.break.label}{labels for pooled p-value breaks. Corresponding default are c("[0,0.05)","[0.05,1]").}

\item{padjust.pool.break}{breaks for multiple testing adjusted p-values to be distinguished in forest plot. Default are c(0,0.1,1).}

\item{padjust.pool.break.label}{labels for  multiple testing adjusted p-value breaks. Corresponding default are c("[0,0.1)","[0.1,1]").}

\item{forest.est.shape}{point shape of pooled estimates in forest plot. Default are c("17","16") for corresponding significant and non-significant pooled estimates.}

\item{forest.est.col}{colors of point (pooled estimates) and 95 CI bars in forest plot. Default are c("red", "black") for significant and non-significant estimates.}

\item{forest.col}{Color of forest plot (point estimates and 95 CI). Options are "by.pvalue" (distinguished by signficant vs. non-significant p-value) or "by.estimate" (color scaled similarly to heatmap color).}

\item{leg.key.size}{legdend key size for heatmap.}

\item{leg.text.size}{legend text size for heatmap.}

\item{heat.text.x.size}{heatmap x label text size.}

\item{heat.text.x.angle}{heatmap x label text angle.}

\item{forest.axis.text.y}{forest plot y label text size.}

\item{forest.axis.text.x}{forest plot x label text size.}

\item{heat.forest.width.ratio}{ratio of width between heatmap and forest plot to be used in grid.arrange. Dedault is c(1,1).}

\item{point.ratio}{ratio of point size between significant pooled estimate and non-significant pooled estimate. Default is c(3,1).}

\item{line.ratio}{ratio of error bar line size between significant pooled estimate and non-significant pooled estimate. Default is=c(2,1).}
}
\value{
combined heatmap forest plot.
}
\description{
This function displays meta-analysis results of relative abundance as a nice combined heatmap and forest plot. More flexibility/options for plot will be added.
}
\examples{
# load saved GAMLSS-BEZI results of four studies
# for the comparison of bacterial taxa relative abundance
# between genders adjusted for breastfeeding and
# infant age at sample collection
data(tabsex4)
#select only taxonomies of a small phylum for meta-analysis example
# (to save running time)
tlm<-tabsex4$id[grep("k__bacteria.p__fusobacteria",tabsex4$id)]
# meta-analysis
metab.sex<-meta.taxa(taxcomdat=tabsex4[tabsex4$id \%in\% tlm,],
summary.measure="RR", pool.var="id", studylab="study", backtransform=FALSE,
percent.meta=0.5, p.adjust.method="fdr")
#show results by table and plot
#phylum
#table
metatab.show(metatab=metab.sex$random,com.pooled.tab=tabsex4[tabsex4$id \%in\% tlm,],
tax.lev="l2",showvar="genderMale",p.cutoff.type="p", p.cutoff=1,display="table")
#plot
metadat<-metatab.show(metatab=metab.sex$random, com.pooled.tab=tabsex4[tabsex4$id \%in\% tlm,],
tax.lev="l2", showvar="genderMale",p.cutoff.type="p", p.cutoff=1,display="data")
meta.niceplot(metadat=metadat,sumtype="taxa",level="main",
p="p",p.adjust="p.adjust", phyla.col="rainbow", p.sig.heat="yes",
heat.forest.width.ratio =c(1.5,1), leg.key.size=0.8, leg.text.size=10,
heat.text.x.size=10, heat.text.x.angle=0, forest.axis.text.y=8,
forest.axis.text.x=10, point.ratio = c(4,2),line.ratio = c(2,1))
}
\keyword{forest}
\keyword{heatmap}
\keyword{meta-analysis}
\keyword{plot.}
