% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pathway.compare.R
\name{pathway.compare}
\alias{pathway.compare}
\title{Compare (kegg) pathway abundance}
\usage{
pathway.compare(pathtab, mapfile, sampleid = "sampleid",
  pathsum = "rel", stat.med = "gamlss", transform = "none", comvar,
  adjustvar, personid = "personid", longitudinal = "yes",
  p.adjust.method = "fdr", percent.filter = 0.05,
  relabund.filter = 5e-05, pooldata = FALSE)
}
\arguments{
\item{pathtab}{list of pathway abundance table of all levels.}

\item{mapfile}{mapping file or file containing covariates.}

\item{sampleid}{variable containing sample id to be matched between pathway abundance table and mapping file.}

\item{pathsum}{type of abundance to be compared. Options are "rel" for relative abundance or "log" for log of absolute abundance. Default is "rel".}

\item{stat.med}{statistical method for comparison. stat.med can be "lm" for LM/LMEM (usable for both pathsum="rel" or "log") or "gamlss" for GAMLSS with BEZI family (gamlss only make sense if pathsum="rel" ).}

\item{transform}{transformation of relative abundance data. Options are "none" for no transformation, "asin.sqrt" for arcsine transformation, "logit" for logit transformation. Default is "none".}

\item{comvar}{main variable for comparison.}

\item{adjustvar}{variables to be adjusted.}

\item{personid}{name of variable for person id in mapping file (applicable for longitudinal data)}

\item{longitudinal}{whether the data is longitudinal. Default is "yes".}

\item{p.adjust.method}{method for multiple testing adjustment. Available options are those of the p.adjust function. Default is "fdr".}

\item{percent.filter}{prevalence threshold (the percentage of number of samples the taxa/pathway available). Default is 0.05.}

\item{relabund.filter}{relative abundance threshold (the minimum of the average relative abundance for a taxa/pathway to be retained). Default is 0.00005.}

\item{pooldata}{whether the data is pooled from multiple studies. Default is FALSE.}
}
\value{
matrice of coefficients, standard errors, p-values and multiple testing adjusted p-values of all variables in the models.
}
\description{
This is a slightly modified version of the taxa.compare function.
It compares pathway abundance generated from PICRUSt analysis between groups using different methods (apply to pathway summary tables already merged to mapping file and put in a list (e.g.level 1, 2 and 3)).
Specifically, it compares relative abundances of bacterial functional pathways at all levels using GAMLSS or LM/LMEM and compares of log(absolute abundances) of bacterial functional pathways at all levels using LM/LMEM.
}
\examples{
#Load Bangladesh pathway and metadata
data(kegg.12)
data(covar.rm)
# Comparison of pathway relative abundances for some first pathways of level 1 only
# and assuming crosssectional data (to save running time)
path1<-pathway.compare(pathtab=list(kegg.12[[1]][, 1:2]),
mapfile=covar.rm,sampleid="sampleid",pathsum="rel", stat.med="gamlss",
comvar="gender",adjustvar=c("age.sample","bf"), longitudinal="no",
p.adjust.method="fdr", percent.filter=0.05,relabund.filter=0.00005)
taxcomtab.show(taxcomtab=path1$l1, sumvar="path",tax.lev="l2",
tax.select="none", showvar="genderMale", p.adjust.method="fdr",p.cutoff=1)
}
\keyword{abundance}
\keyword{comparison.}
\keyword{pathway}
