% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/oecalc.R
\name{oecalc}
\alias{oecalc}
\title{Calculate the total O:E ratio}
\usage{
oecalc(OE, OE.se, OE.cilb, OE.ciub, OE.cilv, citl, citl.se, N, O, E, Po, Po.se,
  Pe, data, slab, add = 1/2, g = NULL, level = 0.95, ...)
}
\arguments{
\item{OE}{vector with the estimated ratio of total observed versus total expected events}

\item{OE.se}{vector with the standard errors of the estimated O:E ratios}

\item{OE.cilb}{vector to specify the lower limits of the confidence interval for \code{OE}.}

\item{OE.ciub}{vector to specify the upper limits of the confidence interval for \code{OE}.}

\item{OE.cilv}{vector to specify the levels of aformentioned confidence interval limits. 
(default: 0.95, which corresponds to the 95\% confidence interval).}

\item{citl}{vector with the estimated calibration-in-the-large statistics}

\item{citl.se}{vector with the standard error of the calibration-in-the-large statistics}

\item{N}{vector to specify the sample/group sizes.}

\item{O}{vector to specify the total number of observed events.}

\item{E}{vector to specify the total number of expected events}

\item{Po}{vector to specify the (cumulative) observed event probabilities.}

\item{Po.se}{vector with the standard errors of \code{Po}.}

\item{Pe}{vector to specify the (cumulative) expected event probabilites
(if specified, during time \code{t.val})}

\item{data}{optional data frame containing the variables given to the arguments above.}

\item{slab}{optional vector with labels for the studies.}

\item{add}{a non-negative number indicating the amount to add to zero counts. See `Details'}

\item{g}{a quoted string that is the function to transform estimates of the total O:E ratio; see the details below.}

\item{level}{level for confidence interval, default \code{0.95}.}

\item{\ldots}{Additional arguments.}
}
\description{
This function calculates (transformed versions of) the ratio of total number of observed versus expected events with the 
corresponding sampling variance.
}
\examples{
######### Validation of prediction models with a binary outcome #########
data(EuroSCORE)

# Calculate the total O:E ratio and its standard error
oecalc(O=n.events, E=e.events, N=n, data=EuroSCORE, slab=Study)

# Calculate the log of the total O:E ratio and its standard error
oecalc(O=n.events, E=e.events, N=n, data=EuroSCORE, slab=Study, g="log(OE)")

}
\author{
Thomas Debray <thomas.debray@gmail.com>
}
\keyword{calibration}
\keyword{meta-analysis}
\keyword{performance}
