% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/split_factors.R
\name{split_factors}
\alias{split_factors}
\alias{as.split_factors}
\alias{is.split_factors}
\title{Split a data frame by factors}
\usage{
split_factors(.data, ..., keep_factors = FALSE)

as.split_factors(.data, keep_factors = FALSE)

is.split_factors(x)
}
\arguments{
\item{.data}{The data that will be split. Must contain at least one grouping
variable.}

\item{...}{Comma-separated list of unquoted variable names that will be used
to split the data.}

\item{keep_factors}{Should the grouping columns be kept?}

\item{x}{An object to check for class \code{split_factors}.}
}
\value{
A list where each element is a named level of the grouping factors.
If more than one grouping variable is used, then each element is the
combination of the grouping variables.
}
\description{
Split a data frame into subsets grouping by one or more factors.
}
\details{
This function is used to split a data frame into a named list where each
element is a level of the grouping variable (or combination of grouping
variables).
\itemize{
\item \code{split_factors()} Split a data frame by factors.
\item \code{as.splict_factors()} coerce to an object of class \code{split_factors}
\item \code{is.splict_factors()} check if an object is of class \code{split_factors}
}
}
\examples{
\donttest{
library(metan)

g1 <- split_factors(iris, Species)
g2 <- split_factors(data_ge, ENV, keep_factors = TRUE)

spdata <- as.split_factors(iris)

is.split_factors(spdata)
}

}
\author{
Tiago Olivoto \email{tiagoolivoto@gmail.com}
}
