% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/coclustering.R
\name{cocluster_density}
\alias{cocluster_density}
\title{Density plot coclustering stability across subsampled data.}
\usage{
cocluster_density(cocluster_df)
}
\arguments{
\item{cocluster_df}{A data frame containing coclustering data for a single
cluster solution. This object is generated by the \code{calculate_coclustering}
function.}
}
\value{
Density plot (class "gg", "ggplot") of the distribution of
coclustering across pairs and subsamples of the data.
}
\description{
This function creates a density plot that shows, for all pairs of
observations that originally clustered together, the distribution of the
the fractions that those pairs clustered together across subsampled data.
}
\examples{
# my_dl <- data_list(
#     list(subc_v, "subcortical_volume", "neuroimaging", "continuous"),
#     list(income, "household_income", "demographics", "continuous"),
#     list(pubertal, "pubertal_status", "demographics", "continuous"),
#     uid = "unique_id"
# )
# 
# sc <- snf_config(my_dl, n_solutions = 5, max_k = 40)
# 
# sol_df <- batch_snf(my_dl, sc)
# 
# my_dl_subsamples <- subsample_dl(
#     my_dl,
#     n_subsamples = 20,
#     subsample_fraction = 0.85
# )
# 
# batch_subsample_results <- batch_snf_subsamples(
#     my_dl_subsamples,
#     sc,
#     verbose = TRUE
# )
# 
# coclustering_results <- calculate_coclustering(
#     batch_subsample_results,
#     sol_df,
#     verbose = TRUE
# )
# 
# cocluster_density(cocluster_dfs[[1]])
}
