% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/general.R
\name{meta_general}
\alias{meta_general}
\alias{meta_description}
\alias{meta_subject}
\alias{meta_referrer}
\alias{meta_robots}
\alias{meta_theme_color}
\title{General Metadata Tags}
\usage{
meta_general(
  .meta = meta(),
  application_name = NULL,
  theme_color = NULL,
  description = NULL,
  robots = NULL,
  generator = NULL,
  subject = NULL,
  rating = NULL,
  referrer = NULL
)

meta_description(.meta = meta(), description)

meta_subject(.meta = meta(), subject)

meta_referrer(.meta = meta(), referrer)

meta_robots(.meta = meta(), robots)

meta_theme_color(.meta = meta(), theme_color)
}
\arguments{
\item{.meta}{A \code{meta} object created by \code{\link[=meta]{meta()}} or \code{\link[=as_meta]{as_meta()}}, or returned
by a \verb{meta_*()} object.}

\item{application_name}{Name of web application (only should be used if the
website is used as an app).}

\item{theme_color}{Theme Color for Chrome, Firefox OS and Opera, e.g.
\code{"#00589a"}.}

\item{description}{Short description of the document (limit to 150
characters), This content \emph{may} be used as a part of search engine results.}

\item{robots}{Control the behavior of search engine crawling and indexing,
e.g. \code{"index,follow"}. Valid names are \code{"index"}, \code{"noindex"}, \code{"follow"},
\code{"nofollow"}. May be a vector or a single string with comma-separated
values.

See \url{https://www.robotstxt.org/meta.html} for more information.}

\item{generator}{Identify the software used to build the document (i.e. -
WordPress, Dreamweaver).}

\item{subject}{Short description of your document's subject.}

\item{rating}{Gives a general age rating based on the document's content,
e.g. \code{"General"}.}

\item{referrer}{Allows control over how referrer information is passed, .e.g.
\code{"no-referrer"}. Valid values include \code{"no-referrer"},
\code{"no-referrer-when-downgrade"}, \code{"same-origin"}, \code{"origin"},
\code{"strict-origin"}, \code{"origin-when-cross-origin"},
\code{"strict-origin-when-cross-origin"}, or \code{"unsafe-url"}.}
}
\value{
A \code{meta} object, or a set of \verb{<meta>} HTML tags inside an HTML
\verb{<head>} tag. For use in \code{\link[rmarkdown:html_document]{rmarkdown::html_document()}}, \code{\link[shiny:runApp]{shiny::runApp()}},
or other HTML locations.
}
\description{
Generate metadata tags for general website properties.
}
\examples{
meta() \%>\%
  meta_general(
    application_name = "Application Name",
    theme_color = "#4285f4",
    description = "A description of this page",
    robots = "index,follow",
    generator = "R-Shiny",
    subject = "Awesome R projects",
    rating = "General",
    referrer = "no-referrer"
  )

}
\seealso{
Other meta: 
\code{\link{meta_apple_itunes_app}()},
\code{\link{meta_apple_web_app}()},
\code{\link{meta_geo}()},
\code{\link{meta_google_scholar}()},
\code{\link{meta_name}()},
\code{\link{meta_social}()},
\code{\link{meta_tag}()},
\code{\link{meta_viewport}()},
\code{\link{meta}()}
}
\concept{meta}
