SpatialPointsTopography<-function(points, elevation, slope, aspect, proj4string = CRS(as.character(NA))) {
  if(!(inherits(points,"SpatialPoints")|| inherits(points,"matrix"))) stop("'points' has to be of class 'matrix' or 'SpatialPoints'.")
  if(inherits(points,"SpatialPoints")) {
    npoints = nrow(points@coords)
    proj4string =points@proj4string
    coords = points@coords
    bbox = points@bbox
  } else {
    coords  = as.matrix(points)
    npoints = nrow(coords)
    bbox = bbox(SpatialPoints(coords))
  }
  if(length(elevation)!=npoints) stop("'elevation' has to be of length equal to the number of points")
  if(length(slope)!=npoints) stop("'slope' has to be of length equal to the number of points")
  if(length(aspect)!=npoints) stop("'aspect' has to be of length equal to the number of points")
  data = data.frame(elevation = elevation, slope = slope, aspect = aspect)
  lt = new("SpatialPointsTopography",
          coords = coords,
          bbox = bbox,
          proj4string = proj4string,
          data = data)
  return(lt)
}
