% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ParamTMoE.R
\docType{class}
\name{ParamTMoE-class}
\alias{ParamTMoE-class}
\alias{ParamTMoE}
\title{A Reference Class which contains parameters of a TMoE model.}
\description{
ParamTMoE contains all the parameters of a TMoE model.
}
\section{Fields}{

\describe{
\item{\code{X}}{Numeric vector of length \emph{n} representing the covariates/inputs
\eqn{x_{1},\dots,x_{n}}.}

\item{\code{Y}}{Numeric vector of length \emph{n} representing the observed
response/output \eqn{y_{1},\dots,y_{n}}.}

\item{\code{n}}{Numeric. Length of the response/output vector \code{Y}.}

\item{\code{K}}{The number of experts.}

\item{\code{p}}{The order of the polynomial regression for the experts.}

\item{\code{q}}{The order of the logistic regression for the gating network.}

\item{\code{alpha}}{Parameters of the gating network. \eqn{\boldsymbol{\alpha} =
  (\boldsymbol{\alpha}_{1},\dots,\boldsymbol{\alpha}_{K-1})}{\alpha =
  (\alpha_{1},\dots,\alpha_{K-1})} is a matrix of dimension \eqn{(q + 1, K -
  1)}, with \code{q} the order of the logistic regression for the gating network.
\code{q} is fixed to 1 by default.}

\item{\code{beta}}{Polynomial regressions coefficients for each expert.
\eqn{\boldsymbol{\beta} =
  (\boldsymbol{\beta}_{1},\dots,\boldsymbol{\beta}_{K})}{\beta =
  (\beta_{1},\dots,\beta_{K})} is a matrix of dimension \eqn{(p + 1, K)},
with \code{p} the order of the polynomial regression. \code{p} is fixed to 3 by
default.}

\item{\code{sigma2}}{The variances for the \code{K} mixture components (matrix of size
\eqn{(1, K)}).}

\item{\code{nu}}{The degree of freedom for the Student distribution for each
experts (matrix of size \eqn{(1, K)}).}

\item{\code{df}}{The degree of freedom of the TMoE model representing the
complexity of the model.}
}}

\section{Methods}{

\describe{
\item{\code{initParam(segmental = FALSE)}}{Method to initialize parameters \code{alpha}, \code{beta} and
      \code{sigma2}.

      If \code{segmental = TRUE} then \code{alpha}, \code{beta} and
      \code{sigma2} are initialized by clustering the response \code{Y}
      uniformly into \code{K} contiguous segments. Otherwise, \code{alpha},
      \code{beta} and \code{sigma2} are initialized by clustering randomly
      the response \code{Y} into \code{K} segments.}

\item{\code{MStep(statTMoE, verbose_IRLS)}}{Method which implements the M-step of the EM algorithm to learn the
parameters of the TMoE model based on statistics provided by the object
\code{statTMoE} of class \link{StatTMoE} (which contains the E-step).}
}}

