% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/evalue_data_chk.R
\name{evalue_buildin_var_fmt_nm}
\alias{evalue_buildin_var_fmt_nm}
\title{Build-in check file format function
Perform the format check and data clean for the  "metilene" or "biseq", "DMRfinder" or "methylKit" method correspondingly.}
\usage{
evalue_buildin_var_fmt_nm(a, b, method = "metilene")
}
\arguments{
\item{a}{data frame of the methylation rate}

\item{b}{data frame of output data corresponding to the "method" option}

\item{method}{"metilene" or "biseq", "DMRfinder" or "methylKit"}
}
\value{
list(a, b) which contains the cleaned data correspondingly
}
\description{
Build-in check file format function
Perform the format check and data clean for the  "metilene" or "biseq", "DMRfinder" or "methylKit" method correspondingly.
}
\examples{
\donttest{
data("demo_metilene_out")
data("demo_metilene_input")
evalue_buildin_var_fmt_nm(demo_metilene_input,
                          demo_metilene_out, method="metilene")
}
}
