% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calcField.R
\name{calcField}
\alias{calcField}
\title{Calculate phylogenetic and trait fields}
\usage{
calcField(field.input, metrics)
}
\arguments{
\item{field.input}{Prepped field.input object.}

\item{metrics}{Optional. If not provided, defines the metrics as all of those in
defineMetrics. If only a subset of those is desired, then metrics should take
the form of a character vector corresponding to named functions from defineMetrics.
The available metrics can be determined by running names(defineMetrics()). Otherwise,
if the user would like to define a new metric on the fly, the argument can take
the form of a named list of new functions (metrics).}
}
\value{
A data frame with the calculated metrics and the associated species richness
of all input "communities".
}
\description{
Given a prepped field.input object, calculate all fields of interest.
}
\details{
Currently we are calculating 19 phylogenetic community structure metrics.
This function first confirms that the input is of class metrics.input and, if so, then
confirms that the metrics to be calculated are in a named list (via checkMetrics),
then lapplies all metric functions to the input metrics.input object.
}
\examples{
#simulate tree with birth-death process
tree <- geiger::sim.bdtree(b=0.1, d=0, stop="taxa", n=50)

sim.abundances <- round(rlnorm(5000, meanlog=2, sdlog=1)) + 1

cdm <- simulateComm(tree, richness.vector=10:25, abundances=sim.abundances)

#in this example, occasionally some species are not in the CDM, so prune the tree
#accordingly so as not to throw any errors
tree <- drop.tip(tree, setdiff(tree$tip.label, colnames(cdm)))

prepped <- prepFieldData(tree=tree, picante.cdm=cdm)

results <- calcField(prepped)
}
\references{
Miller, E. T., D. R. Farine, and C. H. Trisos. 2016. Phylogenetic community
structure metrics and null models: a review with new methods and software.
Ecography DOI: 10.1111/ecog.02070
}
