% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/metrica-package.R
\docType{package}
\name{metrica-package}
\alias{metrica}
\alias{metrica-package}
\title{metrica: Prediction Performance Metrics}
\description{
A compilation of more than 80 functions designed to quantitatively and visually evaluate prediction performance of regression (continuous variables) and classification (categorical variables) of point-forecast models (e.g. APSIM, DSSAT, DNDC, supervised Machine Learning). For regression, it includes functions to generate plots (scatter, tiles, density, & Bland-Altman plot), and to estimate error metrics (e.g. MBE, MAE, RMSE), error decomposition (e.g. lack of accuracy-precision), model efficiency (e.g. NSE, E1, KGE), indices of agreement (e.g. d, RAC), goodness of fit (e.g. r, R2), adjusted correlation coefficients (e.g. CCC, dcorr), symmetric regression coefficients (intercept, slope), and mean absolute scaled error (MASE) for time series predictions. For classification (binomial and multinomial), it offers functions to generate and plot confusion matrices, and to estimate performance metrics such as accuracy, precision, recall, specificity, F-score, Cohen's Kappa, G-mean, and many more. For more details visit the vignettes \url{https://adriancorrendo.github.io/metrica/}.
}
\seealso{
Useful links:
\itemize{
  \item \url{https://adriancorrendo.github.io/metrica/}
  \item Report bugs at \url{https://github.com/adriancorrendo/metrica/issues}
}

}
\author{
\strong{Maintainer}: Adrian A. Correndo \email{correndo@ksu.edu} (\href{https://orcid.org/0000-0002-4172-289X}{ORCID}) [copyright holder]

Authors:
\itemize{
  \item Adrian A. Correndo \email{correndo@ksu.edu} (\href{https://orcid.org/0000-0002-4172-289X}{ORCID})
  \item Luiz H. Moro Rosso \email{lhmrosso@ksu.edu} (\href{https://orcid.org/0000-0002-8642-911X}{ORCID})
  \item Rai Schwalbert \email{rai.schwalbert@hotmail.com} (\href{https://orcid.org/0000-0001-8488-7507}{ORCID})
  \item Carlos Hernandez \email{carlosh92@ksu.edu} (\href{https://orcid.org/0000-0000-0000-0000}{ORCID})
  \item Leonardo M. Bastos \email{leonardombastos@gmail.com} (\href{https://orcid.org/0000-0001-8958-6527}{ORCID})
  \item Luciana Nieto \email{lnieto@ksu.edu}
  \item Dean Holzworth \email{dean.holzworth@csiro.au}
  \item Ignacio A. Ciampitti \email{ciampitti@ksu.edu} (\href{https://orcid.org/0000-0001-9619-5129}{ORCID})
}

}
\keyword{internal}
