% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/twostage.R
\name{survival.iterative}
\alias{survival.iterative}
\title{Survival model for multivariate survival data}
\usage{
survival.iterative(margsurv, data = sys.parent(),
  score.method = "fisher.scoring", Nit = 60, detail = 0,
  clusters = NULL, silent = 1, weights = NULL, control = list(),
  theta = NULL, theta.des = NULL, var.link = 1, iid = 1,
  step = 0.5, model = "clayton.oakes", marginal.trunc = NULL,
  marginal.survival = NULL, marginal.status = NULL, strata = NULL,
  se.clusters = NULL, max.clust = NULL, numDeriv = 0,
  random.design = NULL, pairs = NULL, pairs.rvs = NULL,
  numDeriv.method = "simple", additive.gamma.sum = NULL, var.par = 1,
  cr.models = NULL, case.control = 0, ascertained = 0, shut.up = 0)
}
\arguments{
\item{margsurv}{Marginal model}

\item{data}{data frame}

\item{score.method}{Scoring method "fisher.scoring", "nlminb", "optimize", "nlm"}

\item{Nit}{Number of iterations}

\item{detail}{Detail}

\item{clusters}{Cluster variable}

\item{silent}{Debug information}

\item{weights}{Weights}

\item{control}{Optimization arguments}

\item{theta}{Starting values for variance components}

\item{theta.des}{design for dependence parameters, when pairs are given this is could be a
(pairs) x (numer of parameters)  x (max number random effects) matrix}

\item{var.link}{Link function for variance}

\item{iid}{Calculate i.i.d. decomposition}

\item{step}{Step size}

\item{model}{model}

\item{marginal.trunc}{marginal left truncation probabilities}

\item{marginal.survival}{optional vector of marginal survival probabilities}

\item{marginal.status}{related to marginal survival probabilities}

\item{strata}{strata for fitting, see example}

\item{se.clusters}{for clusters for se calculation with iid}

\item{max.clust}{max se.clusters for se calculation with iid}

\item{numDeriv}{to get numDeriv version of second derivative, otherwise uses sum of squared score}

\item{random.design}{random effect design for additive gamma model, when pairs are given this is
a (pairs) x (2) x (max number random effects) matrix, see pairs.rvs below}

\item{pairs}{matrix with rows of indeces (two-columns) for the pairs considered in the pairwise
composite score, useful for case-control sampling when marginal is known.}

\item{pairs.rvs}{for additive gamma model and random.design and theta.des are given as arrays,
this specifice number of random effects for each pair.}

\item{numDeriv.method}{uses simple to speed up things and second derivative not so important.}

\item{additive.gamma.sum}{for two.stage=0, this is specification of the lamtot in the models via
a matrix that is multiplied onto the parameters theta (dimensions=(number random effects x number
of theta parameters), when null then sums all parameters.}

\item{var.par}{is 1 for the default parametrization with the variances of the random effects,
var.par=0 specifies that the \eqn{\lambda_j}'s are used as parameters.}

\item{cr.models}{competing risks models for two.stage=0, should be given as a list with models for each cause}

\item{case.control}{assumes case control structure for "pairs" with second column being the probands,
when this options is used the twostage model is profiled out via the paired estimating equations for the
survival model.}

\item{ascertained}{if the pair are sampled only when there is an event. This is in contrast to
case.control sampling where a proband is given. This can be combined with control probands. Pair-call
of twostage is needed  and second column of pairs are the first jump time with an event for ascertained pairs,
or time of control proband.}

\item{shut.up}{to make the program more silent in the context of iterative procedures for case-control
and ascertained sampling}
}
\description{
Fits additive gamma frailty model 
with additive hazard condtional on the random effects
\deqn{
\lambda_{ij} = (V_{ij}^T Z) (X_{ij}^T \alpha(t)) 
}
The baseline \eqn{\alpha(t)} is profiled out using
marginal modelling adjusted for the random effects structure as in Eriksson and Scheike (2015).
One advantage of the standard frailty model is that one can deal with competing risks 
for this model. 

For all models the 
standard errors do not reflect this uncertainty of the baseline estimates, and might therefore be a bit to small.
To remedy this one can do bootstrapping or use survival.twostage.fullse function when possible.

If clusters contain more than two times, we use a composite likelihood
based on the pairwise bivariate models. Can also fit a additive gamma random
effects model described in detail below.

We allow a regression structure for the indenpendent gamma distributed 
random effects  and their variances that may depend on cluster covariates. So
\deqn{
 \theta = z_j^T \alpha
}
where \eqn{z} is specified by theta.des 
The reported standard errors are based on the estimated information from the 
likelihood assuming that the marginals are known. 

Can also fit a structured additive gamma random effects model, such
as the ACE, ADE model for survival data. 

Now random.design specificies the random effects for each subject within a cluster. This is
a matrix of 1's and 0's with dimension n x d.  With d random effects. 
For a cluster with two subjects, we let the random.design rows be 
 \eqn{v_1} and \eqn{v_2}. 
Such that the random effects for subject 
1 is \deqn{v_1^T (Z_1,...,Z_d)}, for d random effects. Each random effect
has an associated parameter \eqn{(\lambda_1,...,\lambda_d)}. 
By construction subjects 1's random effect are Gamma distributed with 
mean \eqn{\lambda_j/v_1^T \lambda}
and variance \eqn{\lambda_j/(v_1^T \lambda)^2}. Note that the random effect 
\eqn{v_1^T (Z_1,...,Z_d)} has mean 1 and variance \eqn{1/(v_1^T \lambda)}.
It is here asssumed that  \eqn{lamtot=v_1^T \lambda} is fixed over all clusters
as it would be for the ACE model below.
The lamtot parameter may be specified separately for some sets of the parameter
is the additive.gamma.sum (ags) matrix is specified and then lamtot for the 
j'th random effect is \eqn{ags_j^T \lambda}.

Based on these parameters the relative contribution (the heritability, h) is 
equivalent to  the expected values of the random effects  \eqn{\lambda_j/v_1^T \lambda}

The DEFAULT parametrization uses the variances of the random effecs 
\deqn{
\theta_j  = \lambda_j/(v_1^T \lambda)^2
}
For alternative parametrizations one can specify how the parameters relate to \eqn{\lambda_j}
with the function 

Given the random effects the survival distributions with a cluster are independent and
on the form 
\deqn{
P(T > t| x,z) = exp( -Z  A(t) \exp( Z^t beta))
}

The parameters \eqn{(\lambda_1,...,\lambda_d)}
are related to the parameters of the model
by a regression construction \eqn{pard} (d x k), that links the \eqn{d} 
\eqn{\lambda} parameters
with the (k) underlying \eqn{\theta} parameters 
\deqn{
\lambda = theta.des  \theta 
}
here using theta.des to specify these low-dimension association. Default is a diagonal matrix. 

The case.control option that can be used with the pair specification of the pairwise parts
of the estimating equations. Here it is assumed that the second subject of each pair is the
proband.
}
\author{
Thomas Scheike
}
\keyword{survival}
