% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mle.R
\name{gev.mle}
\alias{gev.mle}
\title{Generalized extreme value maximum likelihood estimates for various quantities of interest}
\usage{
gev.mle(xdat, args = c("loc", "scale", "shape", "quant", "Nmean",
  "Nquant"), N, p, q)
}
\arguments{
\item{xdat}{sample vector of maxima}

\item{args}{vector of strings indicating which arguments to return the maximum likelihood values for.}

\item{N}{size of block over which to take maxima. Required only for \code{args} \code{Nmean} and \code{Nquant}.}

\item{p}{tail probability. Required only for \code{arg} \code{quant}.}

\item{q}{level of quantile for maxima of \code{N} exceedances. Required only for \code{args} \code{Nquant}.}
}
\value{
named vector with maximum likelihood estimated parameter values for arguments \code{args}
}
\description{
This function calls the \code{fit.gev} routine on the sample of block maxima and returns maximum likelihood
estimates for all quantities of interest, including location, scale and shape parameters, quantiles and mean and
quantiles of maxima of \code{N} blocks.
}
\examples{
dat <- evd::rgev(n = 100, shape = 0.2)
gev.mle(xdat = dat, N = 100, p = 0.01, q = 0.5)
}
