% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/univdist.R
\name{gpdr}
\alias{gpdr}
\title{Generalized Pareto distribution (return level parametrization)}
\arguments{
\item{par}{vector of length 2 containing \eqn{y_m} and \eqn{\xi}, respectively the \eqn{m}-year return level and the shape parameter.}

\item{dat}{sample vector}

\item{m}{number of observations of interest for return levels. See \strong{Details}}

\item{tol}{numerical tolerance for the exponential model}

\item{method}{string indicating whether to use the expected  (\code{'exp'}) or the observed (\code{'obs'} - the default) information matrix.}

\item{nobs}{number of observations}

\item{V}{vector calculated by \code{gpdr.Vfun}}
}
\description{
Likelihood, score function and information matrix,
approximate ancillary statistics and sample space derivative
for the generalized Pareto distribution parametrized in terms of return levels.
}
\details{
The observed information matrix was calculated from the Hessian using symbolic calculus in Sage.

The interpretation for \code{m} is as follows: if there are on average \eqn{m_y} observations per year above the threshold, then  \eqn{m=Tm_y} corresponds to \eqn{T}-year return level.
}
\section{Usage}{
 \preformatted{gpdr.ll(par, dat, m, tol=1e-5)
gpdr.ll.optim(par, dat, m, tol=1e-5)
gpdr.score(par, dat, m)
gpdr.infomat(par, dat, m, method = c('obs', 'exp'), nobs = length(dat))
gpdr.Vfun(par, dat, m)
gpdr.phi(par, V, dat, m)
gpdr.dphi(par, V, dat, m)}
}

\section{Functions}{


\itemize{
\item{\code{gpdr.ll}:} {log likelihood}
\item{\code{gpdr.ll.optim}:} {negative log likelihood parametrized in terms of \code{log(scale)} and shape
in order to perform unconstrained optimization}
\item{\code{gpdr.score}:} {score vector}
\item{\code{gpdr.infomat}:} {observed information matrix for GPD parametrized in terms of rate of \eqn{m}-year return level and shape}
\item{\code{gpdr.Vfun}:} {vector implementing conditioning on approximate ancillary statistics for the TEM}
\item{\code{gpdr.phi}:} {canonical parameter in the local exponential family approximation}
\item{\code{gpdr.dphi}:} {derivative matrix of the canonical parameter in the local exponential family approximation}
}
}

\author{
Leo Belzile
}
