% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mevr.R
\name{dtmev}
\alias{dtmev}
\alias{ptmev}
\alias{qtmev}
\title{The non-stationary Metastatistical Extreme Value Distribution}
\usage{
dtmev(x, data)

ptmev(q, data)

qtmev(p, data)
}
\arguments{
\item{x, q}{Numeric vector or single value of probabilities for \code{dtmev}.}

\item{data}{A data frame with at least columns \code{c}, \code{w} and \code{year}. 
Can be taken from the output of the fitted TMEV object, i.e. \code{x$data} (see \code{\link{ftmev}}).}

\item{p}{Numeric vector or single value of probabilities for \code{qtmev}.}
}
\value{
\code{dtmev} gives the density function, \code{ptmev} gives the distribution function, 
and \code{qtmev} gives the quantile function of the TMEV.
}
\description{
Quantile function for the TMEV distribution with a Weibull parent distribution.
}
\section{Functions}{
\itemize{
\item \code{ptmev()}: distribution quantile function

\item \code{qtmev()}: distribution quantile function

}}
\examples{
data(dailyrainfall)
fit <- ftmev(dailyrainfall)
rp <- pp.weibull(fit$maxima)
rl <- qtmev(1 - 1 / rp, fit$data)
plot(rp, sort(fit$maxima), main = "TMEV", ylab = "return level", xlab = "return period (years)")
lines(rp, rl, type = "l")


}
