\name{gadget_likelihood_component}
\alias{gadget_likelihood_component}

\title{Gadget likelihood components}
\description{
    Structures representing a component of a GADGET likelihood file.
}

\usage{
gadget_likelihood_component(type, weight = 0, name = type,
    likelihoodfile = 'likelihood', ...)
}

\arguments{
    \item{type}{
        Type of group to create. One of penalty, understocking, catchstatistics,
        catchdistribution, stockdistribution.
    }
    \item{name}{
        A descriptive name for the component
    }
    \item{weight}{
        A numeric weighting
    }
    \item{likelihoodfile}{
        The likelihood file this component should end up in
    }
    \item{...}{
        Extra parameters for the group. See details.
    }
}

\details{
In addition, \code{penalty} understands:
\describe{
    \item{data}{A \code{data.frame} with 2 columns, "switch" and "power"}
}

\code{catchstatistics} understands:
\describe{
    \item{data_function}{The function Gadget should use, by default guesses based on the function that generated \code{data}}
    \item{data}{A \code{data.frame} probably generated by \code{mfdb_sample_meanlength_stddev}}
    \item{area}{An \code{list} of areas, taken from \code{attr(data, "area")} if not supplied}
    \item{age}{An \code{list} of ages, taken from \code{attr(data, "age")} if not supplied}
    \item{fleetnames}{List of fleet names}
    \item{stocknames}{List of stock names}
}

\code{catchdistribution} understands:
\describe{
    \item{data_function}{The function Gadget should use, by default uses sumofsquares}
    \item{data_function_params}{Extra parameters to supply to gadget, based on the function}
    \item{aggregationlevel}{TRUE or FALSE, defaults to FALSE}
    \item{overconsumption}{TRUE or FALSE, defaults to FALSE}
    \item{epsilon}{Numeric, defaults to 10}
    \item{data}{A \code{data.frame} probably generated by \code{mfdb_sample_meanlength_stddev}}
    \item{area}{An \code{list} of areas, taken from \code{attr(data, "area")} if not supplied}
    \item{age}{An \code{list} of ages, taken from \code{attr(data, "age")} if not supplied}
    \item{length}{An \code{list} of lengths, taken from \code{attr(data, "length")} if not supplied}
    \item{fleetnames}{List of fleet names}
    \item{stocknames}{List of stock names}
}

\code{stockdistribution} understands:
\describe{
    \item{data_function}{The function Gadget should use, by default uses sumofsquares}
    \item{overconsumption}{TRUE or FALSE, defaults to FALSE}
    \item{epsilon}{Numeric, defaults to 10}
    \item{data}{A \code{data.frame} probably generated by \code{mfdb_sample_meanlength_stddev}}
    \item{area}{An \code{list} of areas, taken from \code{attr(data, "area")} if not supplied}
    \item{age}{An \code{list} of ages, taken from \code{attr(data, "age")} if not supplied}
    \item{length}{An \code{list} of lengths, taken from \code{attr(data, "length")} if not supplied}
    \item{fleetnames}{List of fleet names}
    \item{stocknames}{List of stock names}
}

\code{surveydistribution} understands:
\describe{
    \item{data}{A \code{data.frame} probably generated by \code{mfdb_sample_meanlength_stddev}}
    \item{area}{An \code{list} of areas, taken from \code{attr(data, "area")} if not supplied}
    \item{length}{An \code{list} of lengths, taken from \code{attr(data, "length")} if not supplied}
    \item{age}{An \code{list} of ages, taken from \code{attr(data, "age")} if not supplied}
    \item{stocknames}{List of stock names}
    \item{fittype, slope, intercept}{Fit options, see GADGET manual}
    \item{parameters}{A vector of length 2}
    \item{suitability}{A single suitability function}
    \item{epsilon}{Numeric, defaults to 10}
    \item{likelihoodtype}{String, see GADGET manual}
}

\code{surveyindices} understands:
\describe{
    \item{sitype}{What data the component is based on, see GADGET manual}
    \item{biomass}{0 or 1, defaults to 0}
    \item{data}{A \code{data.frame} probably generated by \code{mfdb_sample_meanlength_stddev}}
    \item{area}{An \code{list} of areas, taken from \code{attr(data, "area")} if not supplied}
    \item{age}{An \code{list} of ages, taken from \code{attr(data, "age")} if not supplied}
    \item{length}{An \code{list} of lengths, taken from \code{attr(data, "length")} if not supplied}
    \item{fleetnames}{List of fleet names}
    \item{stocknames}{List of stock names}
    \item{surveynames}{List of acoustic survey names}
    \item{fittype, slope, intercept}{Fit options, see GADGET manual}
}

\code{stomachcontent} understands:
\describe{
    \item{data_function}{Function GADGET will use}
    \item{epsilon}{To be used when calculated probability is low}
    \item{prey_labels}{Either a vector of stock names to be used for all preys, or a list to match preys, see below}
    \item{prey_digestion_coefficients}{Optional. Either a vector of coefficients fo be used for all preys, or a list to match preys, see below}
    \item{predator_names}{Vector of predator stock names}
    \item{data}{A \code{data.frame} probably generated by \code{mfdb_sample_meanlength_stddev}}
}

Both \code{prey_labels} and \code{prey_digestion_coefficients} allow you to
match parts of prey labels and use repetition. For instance,
\code{list("cod.mat" = "mature_cod", "cod" = "cod", "other")} will give
"cod.mat" the label "mature_cod", "cod.imm" the label "cod", and anything
else will get "other". You can also use regular expression syntax, for example
"cod[0-9]".

\code{migrationpenalty} understands:
\describe{
    \item{stockname}{Stock name}
    \item{powercoeffs}{2 power coefficients}
}

}

\value{
A gadget_likelihood_component object that can then be written to a likelihood
file with \code{gadget_dir_write}
}

\examples{
# Create a penalty component
component <- gadget_likelihood_component("penalty",
        name = "bounds",
        weight = "0.5",
        data = data.frame(
            switch = c("default"),
            power = c(2),
            stringsAsFactors = FALSE))
component

# Create an understocking component
component <- gadget_likelihood_component("understocking", name ="understock")
component

# Any example could be added to a file with the following:-
gd <- gadget_directory(tempfile())
gadget_dir_write(gd, component)
}
