% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/shine.qqGam.R
\name{shine.qqGam}
\alias{shine.qqGam}
\title{Shiny QQ-plots for GAMs}
\usage{
\method{shine}{qqGam}(o, ...)
}
\arguments{
\item{o}{the output of \link{qq.gamViz}.}

\item{...}{currently not used.}
}
\description{
This function takes the output of \link{qq.gamViz} and transforms it
into an interactive shiny app.
}
\details{
In RStudio, this function returns a call to \code{qq.gamViz} that reproduces the last plot
rendered in the interactive shiny window.
}
\examples{
\dontrun{

## simulate binomial data...
library(mgcv)
library(mgcViz)
set.seed(0)
n.samp <- 400
dat <- gamSim(1,n = n.samp, dist = "binary", scale = .33)
p <- binomial()$linkinv(dat$f) ## binomial p
n <- sample(c(1, 3), n.samp, replace = TRUE) ## binomial n
dat$y <- rbinom(n, n, p)
dat$n <- n
lr.fit <- gam(y/n ~ s(x0) + s(x1) + s(x2) + s(x3)
              , family = binomial, data = dat,
              weights = n, method = "REML")
lr.fit <- getViz(lr.fit)
# launch shiny gagdet
shine(qq(lr.fit))
 
}

}
