% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/addSqtlSeek_function.R
\name{addSqtlSeek}
\alias{addSqtlSeek}
\title{Add results from SqtlSeek splicingQTL algorithm to list}
\usage{
addSqtlSeek(mgl, download = TRUE, saveDownload = FALSE, fpsource = "./")
}
\arguments{
\item{mgl}{List; see \code{\link{buildFromNames}}, \code{\link{buildFromRegion}}, or \code{\link{buildFromEnsgs}}}

\item{download}{A logical vector indicating if the data should be downloaded.}

\item{saveDownload}{A logical vector indicating if the data should be saved as 'RawData_sqtlSeek.RData'}

\item{fpsource}{A character string of with the filepath where the data has been downloaded}
}
\description{
\code{addSqtlSeek} returns an 'mgl' list with the fifteenth element as a dataframe containing results from SqtlSeek splicingQTL algorithm from GTEx; see \url{http://www.gtexportal.org}.
}
\details{
This gives the SqtlSeek algorithm results for each gene.  Data is downloaded from the GTEx website \url{http://www.gtexportal.org/static/datasets/gtex_analysis_pilot_v3/splicing_qtls_sqtls/sQTLs-sQTLseeker-merged.tgz}.
}
\examples{
\dontrun{buildFromRegion(chr = 2, start = 102314000, stop = 103435000) -> myMgl}
\dontrun{myMgl <- addSqtlSeek(myMgl)}

}
\seealso{
Other elements: \code{\link{addAei}},
  \code{\link{addAntisense}}, \code{\link{addCisEqtl}},
  \code{\link{addDnase}}, \code{\link{addEnst}},
  \code{\link{addExpression}}, \code{\link{addGo}},
  \code{\link{addGrasp}}, \code{\link{addGwasCatalog}},
  \code{\link{addLoc}}, \code{\link{addPtv}},
  \code{\link{addPubmed}}, \code{\link{addSqtlAltrans}},
  \code{\link{addTransEqtl}}, \code{\link{missNames}}
}

