% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/makeGo_function.R
\name{makeGo}
\alias{makeGo}
\title{Returns a list with Gene Ontology data}
\usage{
makeGo(mgl, saveFile = TRUE)
}
\arguments{
\item{mgl}{List; see \code{\link{buildFromNames}}, \code{\link{buildFromRegion}}, or \code{\link{buildFromEnsgs}}}

\item{saveFile}{A logical flag indicating whether two csv files: 'GoTable.csv' and 'GoCount.csv' should be saved in the current directory}
}
\description{
\code{makeGo} returns a list with three elements summarizing Gene Ontology (GO) terms.  The first element (goRes) is the GO results subsetted from the mgl.  The second element (goTable) is a dataframe with two columns: GO terms and gene names.  The third element (goCount) is a table with the number of elements corresponding to the number of unique GO terms in the genelist - reported for each GO term is the number of times it appears.  It is sorted in descending order.The structure is similar to the \code{\link{makePhenotypes}} and \code{\link{makeSnps}} functions.
}
\details{
Provides a brief summary of GO terms that have been associate with candidate genes. Of interest maybe groups of genes that have the same GO term see \code{makeGoSearch}.
}
\examples{
exMgl() -> myMgl
makeGo(myMgl, saveFile = TRUE) -> myGo

}
\seealso{
Other output: \code{\link{makeAeiPlot}},
  \code{\link{makeCoXpGene}},
  \code{\link{makeCoXpTranscript}},
  \code{\link{makeDnaseSig}}, \code{\link{makeGoSearch}},
  \code{\link{makeMultiEqtl}},
  \code{\link{makeOverlapTable}},
  \code{\link{makeOverlap}},
  \code{\link{makePhenotypeSearch}},
  \code{\link{makePhenotypes}},
  \code{\link{makeSnpSearch}}, \code{\link{makeSnps}},
  \code{\link{makeSummary}}
}

