% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/count_mir_threshold.R
\name{plot_mir_count_threshold}
\alias{plot_mir_count_threshold}
\title{Plot occurrence count of miRNA names over different thresholds}
\usage{
plot_mir_count_threshold(
  df,
  start = 1,
  end = 5,
  bins = NULL,
  colour = "steelblue3",
  col.mir = miRNA,
  col.pmid = PMID,
  title = NULL
)
}
\arguments{
\item{df}{Data frame containing columns with miRNAs and PubMed-IDs.}

\item{start}{Integer or float. Must be greater than 0 and smaller than
\code{end}.}

\item{end}{Integer or float. Must be greater than 0 and greater than
\code{start}.
If \code{start} >= 1, \code{plot_mir_count_threshold()} plots
number of miRNAs above different absolute thresholds, ranging from
\code{start} to \code{end}.
If \code{start} >= 0 and \code{end} <= 1, \code{bins} must be specified. If \code{bins} is
not specified, \code{bins} is automatically set to \code{10}.
\code{plot_mir_count_threshold()} then plots number of miRNAs above different
thresholds, ranging from \code{start} to \code{end} in n \code{bins}.
If \code{start} >= 0 and \code{end} <= 1 and the value of \code{start} is too low for
the number of miRNAs to be plotted, \code{plot_mir_count_threshold()} raises
a warning, suggesting a more appropriate \code{start} value.}

\item{bins}{Integer. Optional. Only necessary if \code{start} >=0
and \code{end} <=1. Specifies number of bins between \code{start} and
\code{end}. If \code{start} >= 0, \code{end} <= 1, and \code{bins} is
not specified, \code{bins} is automatically set to \code{10}.}

\item{colour}{String. Colour of bar plot.}

\item{col.mir}{Symbol. Column containing miRNAs.}

\item{col.pmid}{Symbol. Column containing PubMed-IDs.}

\item{title}{String. Plot title.}
}
\value{
Bar plot counting the occurrence of miRNA names above different
thresholds.
}
\description{
Plot occurrence count of distinct miRNA names over different thresholds.
}
\details{
Plot occurrence of distinct miRNA names over different thresholds.
These thresholds can either be absolute values or floating values between 0
and 1.
If the thresholds are absolute values, number of distinct miRNA names
mentioned in at least n abstracts are plotted, where n
is the range of thresholds defined by \code{start} and \code{end}.
If the thresholds are floating values, \code{bins} must be specified as well.
Then the umber of distinct miRNA names
mentioned in at least n abstracts over \code{bins} are plotted, where n is the
range of thresholds
between \code{start} and \code{end}.
Overall, plotting can help in identifying if the abstracts
at hand mention different miRNAs in a balanced way, or if there are few miRNAs
dominating the field.
}
\seealso{
\code{\link[=count_mir_threshold]{count_mir_threshold()}}, \code{\link[=count_mir]{count_mir()}}, \code{\link[=plot_mir_count]{plot_mir_count()}}

Other count functions: 
\code{\link{count_mir_threshold}()},
\code{\link{count_mir}()},
\code{\link{count_snp}()},
\code{\link{plot_mir_count}()}
}
\concept{count functions}
