% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mica.networks.R
\name{mica.networks}
\alias{mica.networks}
\title{Get the networks}
\usage{
mica.networks(mica, query = "network()", select = list("*"),
  sort = list("id"), from = 0, limit = 100, locale = "en",
  df = TRUE)
}
\arguments{
\item{mica}{A Mica object}

\item{query}{The search query}

\item{select}{The fields to be extracted}

\item{sort}{The fields to sort by}

\item{from}{From item}

\item{limit}{Max number of items}

\item{locale}{The language for labels (default is "en")}

\item{df}{Return a data.frame (default is TRUE)}
}
\description{
Get the networks
}
\examples{
\dontrun{
m <- mica.login("https://mica-demo.obiba.org")
mica.networks(m, query="network(in(Mica_network.studyIds,clsa))")
mica.logout(m)
}
}
