% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/boot.graph.R
\name{boot.graph}
\alias{boot.graph}
\title{Bootstrap Resampling for the PC-MI- and the FCI-MI-algorithm}
\usage{
boot.graph(
  data,
  select = NULL,
  method = c("pcMI", "fciMI"),
  method.mice = NULL,
  args,
  R,
  m = 10,
  args.residuals = NULL,
  seed = NA,
  quickpred = FALSE,
  ...
)
}
\arguments{
\item{data}{Data.frame with missing values}

\item{select}{Variable of integers, indicating columns to select from a data frame;
only continuous variables can be included in the model selection}

\item{method}{Character string specifying the algorithm for causal discovery
from the package 'pcalg'.}

\item{method.mice}{Character string specifying imputation method; see \code{\link[mice:mice]{mice::mice()}} for
more information.}

\item{args}{Arguments passed to \code{method}. NOTE: argument \code{labels} is set
internally and should not be used!}

\item{R}{A positive integer number of bootstrap replications.}

\item{m}{Number of chains included in mice()`.}

\item{args.residuals}{(Optional) list containing vertices and confounders.
May be specified when residuals for vertices should be calculated in each bootstrap
data set. See \code{\link[=makeResiduals]{makeResiduals()}} for more information}

\item{seed}{A positive integer that is used as argument for set.seed().}

\item{quickpred}{If true, mice uses quickpred to select predictors.}

\item{...}{Further arguments passed to the imputation function \code{mice()}.}
}
\value{
List of objects of class \code{pcalgo} (see \link[pcalg:pcAlgo-class]{pcalg::pcAlgo})
or of \code{fcmialgo} (see \link[pcalg:fciAlgo-class]{pcalg::fciAlgo}).
}
\description{
Generate R bootstrap replicates for the PC or FCI algorithm for data with
missing values.
}
\examples{
data(windspeed)
daten <- mice::ampute(windspeed)$amp

\donttest{
bgraph <- boot.graph(data = daten,
                     method = "pcMI",
                     args = "solve.confl = TRUE, alpha = 0.05",
                     R = 5)
}
}
