\name{mipo}
\alias{print.mipo}
\alias{summary.mipo}
\title{Multiply Imputed Pooled Analysis}
\usage{
print.mipo(x,...)
summary.mipo(object,...)
}

\description{
  The "mipo" object is generated by the \code{\link{lm.mids}} and \code{\link{glm.mids}} functions.
  The "mipo" class of objects has methods for the following generic functions:
  print, summary.
}

\arguments{
    \item{x, object}{An object containing the m fit objects of a complete data analysis, 
        plus some additional information.}
    \item{...}{not used.}
}
\value{
  \item{call}{  The call that created the mipo object.}
  \item{call1}{ The call that created the mira object that was used in 'call'.}
  \item{call2}{ The call that created the mids object that was used in 'call1'.}
  \item{nmis}{  An array containing the number of missing observations per column.}
  \item{m}{Number of multiple imputations.}
  \item{qhat}{An m x \code{npar} matrix containing the complete data estimates for the \code{npar} paremeters of the m complete data analyses.}
  \item{u}{An m x \code{npar} x \code{npar} array containing the variance-covariance matrices of the m complete data analyses.}
  \item{qbar}{The average of complete data estimates.}
  \item{ubar}{The average of the variance-covariance matrix of the complete data estimes.}
  \item{b}{The between imputation variance-covariance matrix.}
  \item{t}{The total variance-covariance matrix.}
  \item{r}{Relative increases in variance due to missing data}
  \item{df}{Degrees of freedom associated with the t-statistics.}
  \item{f}{Fractions of missing information.}
}

\references{
  Van Buuren, S. & Oudshoorn, C.G.M. (2000). Multivariate Imputation by Chained Equations: 
  MICE V1.0 User's manual. Report PG/VGZ/00.038, TNO Prevention and Health, Leiden.
}




\author{Stef van Buuren, Karin Oudshoorn, 2000}   

\keyword{misc}  
