% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/as.r
\name{as.mids}
\alias{as.mids}
\title{Converts an multiply imputed dataset (long format) into a \code{mids} object}
\usage{
as.mids(data, .imp=1, .id=2)
}
\arguments{
\item{data}{A multiply imputed data set in long format}

\item{.imp}{Mandatory column indicator for the multiple imputation stream, where \code{0} indicates the incomplete data and \code{1} through \code{m} indicate the \code{m} multiple imputation streams. Default is \code{1}.}

\item{.id}{Optional column indicator for the row numbers. Default is \code{2}.}
}
\value{
An object of class \code{mids}
}
\description{
This function converts imputed data stored in long format into an object of class \code{mids}.
The original incomplete data set needs to be available so that we know where the missing data are.
The function is useful to convert back operations applied to the imputed data
back in a \code{mids} object. It may also be used to store multiply imputed data sets
from other software into the format used by \code{mice}.
}
\details{
If \code{.id} is specified, row names from the original data (if supplied) will be copied to the \code{mids} object.
}
\examples{
# impute the nhanes dataset
imp <- mice(nhanes, print = FALSE)
# extract the data in long format
X <- complete(imp, action = "long", include = TRUE)
# create dataset with .imp variable that is not a factor
X2 <- X
X2$.imp <- as.numeric(levels(X$.imp))[X$.imp]
# nhanes example without .id
test1 <- as.mids(X[, -2], .id = NULL)
is.mids(test1)
all(complete(test1, action = "long", include = TRUE) == X, na.rm = TRUE)
# nhanes example without .id where .imp is not a factor
test2 <- as.mids(X2[, -2], .id = NULL)
is.mids(test2)
all(complete(test1, action = "long", include = TRUE) == X, na.rm = TRUE)
# nhanes example with .id
test3 <- as.mids(X, .id = 2)
is.mids(test3)
all(complete(test1, action = "long", include = TRUE) == X, na.rm = TRUE)
# nhanes example with .id where .imp is not a factor
test4 <- as.mids(X2, .id = 2)
is.mids(test4)
all(complete(test1, action = "long", include = TRUE) == X, na.rm = TRUE)
}
\author{
Gerko Vink
}
\keyword{mids}

