% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mira.r
\docType{class}
\name{mira-class}
\alias{mira}
\alias{mira-class}
\title{Multiply imputed repeated analyses (\code{mira})}
\description{
The \code{mira} object is generated by the \code{with.mids()} function. 
The \code{as.mira()}
function takes the results of repeated complete-data analysis stored as a
list, and turns it into a \code{mira} object that can be pooled. Pooling
requires that \code{coef()} and \code{vcov()} methods are available for
fitted object.  The \code{mira} class of objects has methods for the
following generic functions: \code{print}, \code{summary}.
}
\note{
Many of the functions of the \code{mice} package do not use the S4 class definitions, 
and instead rely on the S3 list equivalent \code{oldClass(obj) <- "mira"}.
}
\section{Slots}{
 
 \describe{
 #'    \item{\code{.Data}:}{Object of class \code{"list"} containing the 
   following slots:}
   \item{\code{call}:}{The call that created the object.}
   \item{\code{call1}:}{The call that created the \code{mids} object that was used
in \code{call}.}
   \item{\code{nmis}:}{An array containing the number of missing observations per
column.}
   \item{\code{analyses}:}{A list of \code{m} components containing the individual
fit objects from each of the \code{m} complete data analyses.}
   }
}
\author{
Stef van Buuren, Karin Groothuis-Oudshoorn, 2000
}
\references{
van Buuren S and Groothuis-Oudshoorn K (2011). \code{mice}:
Multivariate Imputation by Chained Equations in \code{R}. \emph{Journal of
Statistical Software}, \bold{45}(3), 1-67.
\url{http://www.jstatsoft.org/v45/i03/}
}
\seealso{
\code{\link{with.mids}}, \code{\link[=mids-class]{mids}}, \code{\link[=mipo-class]{mipo}}
}
\keyword{classes}

