\name{mira}

%classes
\alias{mira-class}

%functions
\alias{mira}
\alias{is.mira}
\alias{as.mira}

%methods
\alias{print,mira-method}
\alias{summary,mira-method}

\title{Multiply Imputed Repeated Analyses}

\usage{
is.mira(x)
as.mira(fitlist)
\S4method{print}{mira}(x)
\S4method{summary}{mira}(object)
}

\arguments{
\item{x, object}{An object containing the \code{m} fit objects of a complete data analysis, 
        plus some additional information.}
    \item{fitlist}{An list of fitted objects, where each list element
        is a fit object. This can, for example, be produced by the
      \code{by()} function.}
    }

\description{
  The \code{mira} object is generated by the \code{with.mids()}, \code{lm.mids()} and \code{glm.mids()} 
  functions.
The \code{as.mira()} function takes the results of repeated complete-data
analysis stored as a list, and turns it into a \code{mira} object that
can be pooled. Pooling requires that \code{coef()} and \code{vcov()}
methods are available for fitted object. 
  The \code{mira} class of objects has methods for the following generic functions:
  \code{print}, \code{summary}.}

\value{
  \item{call}{  The call that created the object.}
  \item{call1}{ The call that created the \code{mids} object that was used in \code{call}.}
  \item{nmis}{  An array containing the number of missing observations per column.}
  \item{analyses}{ A list of \code{m} components containing the individual fit objects from each of the \code{m} complete data analyses.}
}

\references{
Van Buuren, S., Groothuis-Oudshoorn, K. (2010) 
MICE: Multivariate Imputation by Chained Equations in R. 
\emph{Journal of Statistical Software}, forthcoming.
\url{http://www.stefvanbuuren.nl/publications/MICE in R - Draft.pdf}
}
\author{Stef van Buuren, Karin Groothuis-Oudshoorn, 2000}     
\keyword{classes}  

\seealso{\code{\link{with.mids}}, \code{\link{mids}}, \code{\link{mipo}}}
