% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mice.impute.norm.R
\name{estimice}
\alias{estimice}
\title{Computes least squares parameters}
\usage{
estimice(x, y, ls.meth = "qr", ridge = 1e-05, ...)
}
\arguments{
\item{x}{Matrix (\code{n} x \code{p}) of complete covariates.}

\item{y}{Incomplete data vector of length \code{n}}

\item{ls.meth}{the method to use for obtaining the least squares estimates. By
default parameters are drawn by means of QR decomposition.}

\item{ridge}{A small numerical value specifying the size of the ridge used.
The default value \code{ridge = 1e-05} represents a compromise between stability
and unbiasedness. Decrease \code{ridge} if the data contain many junk variables.
Increase \code{ridge} for highly collinear data.}

\item{...}{Other named arguments.}
}
\value{
A \code{list} containing components \code{c} (least squares estimate),
\code{r} (residuals), \code{v} (variance/covariance matrix) and \code{df}
(degrees of freedom).
}
\description{
This function computes least squares estimates, variance/covariance matrices,
residuals and degrees of freedom according to ridge regression, QR decomposition
or Singular Value Decomposition. This function is internally called by .norm.draw(),
but can be called by any user-specified imputation function.
}
\details{
When calculating the inverse of the crossproduct of the predictor matrix,
problems may arise. For example, taking the inverse is not possible when the
predictor matrix is rank deficient, or when the estimation problem is
computationally singular. This function detects such error cases and
automatically falls back to adding a ridge penalty to the diagonal of the
crossproduct to allow for proper calculation of the inverse.
}
\note{
This functions adds a star to variable names in the mice iteration
history to signal that a ridge penalty was added. In that case, it
also adds an entry to \code{loggedEvents}.
}
\author{
Gerko Vink, 2018
}
