% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/miceRanger.R
\name{miceRanger}
\alias{miceRanger}
\title{miceRanger}
\usage{
miceRanger(
  data,
  m = 5,
  maxiter = 5,
  vars,
  valueSelector = c("meanMatch", "value"),
  meanMatchCandidates = pmax(round(nrow(data) * 0.01), 5),
  parallel = FALSE,
  verbose = TRUE,
  ...
)
}
\arguments{
\item{data}{The data to be imputed. Can contain variables that are not going to be imputed, which you
want to use as features.}

\item{m}{The datasets to produce}

\item{maxiter}{The number of iterations to run for each dataset.}

\item{vars}{A named list of character vectors representing the target/predictors.
List names are the variables to impute, and the elements in the vectors should 
be features used to impute that variable. The order of this list will 
determine the order in which the variables are imputed. Default is to impute
all of the variables in \code{data}, in the same order they exist in the 
data.frame, using all of the columns as features. Any variable in this list that 
contains no missing values will be removed, but will continue to be used as a feature.}

\item{valueSelector}{How to select the value to be imputed from the model predictions. 
Can either use mean matching or use the output from the regression itself. 
\itemize{
  \item {"meanMatch"} Mean matching for regression will select one of \code{meanMatchCandidates} 
  values. These candidates had a predicted value that is closest to the predicted value for that missing sample.
  Mean matching for classification will select a level based on a random sampling weighted by the class
  probability output by the random forest.
  \item {"value"} Returns the predicted output from the random forest. This will be the predicted
  class for classification, and the value for regression. Allows interpolation in regression.
  Can produce better imputations if the data is not very skewed or otherwise nicely distributed.
}}

\item{meanMatchCandidates}{Used for regression. Take a random value from the most similair N values
in the dataset. Defaults to 1 percent of the rows in the dataset, with a minimum of 5.}

\item{parallel}{Should the process run in parallel? This process will take advantage of any cluster 
set up when \code{miceRanger} is called. Use carefully, a copy of \code{data} is sent to
each back end, and then another working copy is created to keep track of imputations. 
Therefore 1 copy exists in the \code{miceRanger} function scope, and 2 copies exist in each 
back end when running in parallel.}

\item{verbose}{should progress be printed?}

\item{...}{other parameters passed to \code{ranger()} to control forest growth.}
}
\value{
a miceDefs object, containing the following:
\item{callParams}{The parameters of the object.}
\item{data}{The original data provided by the user.}
\item{naWhere}{Logical index of missing data, having the same dimensions as data.}
\item{missingCounts}{The number of missing values for each variable}
\item{rawClasses}{The original classes provided in \code{data}}
\item{newClasses}{The new classes of the returned dataset. Classes can be changed if necessary.}
\item{allImps}{The imputations of all variables at each iteration, for each dataset.}
\item{allImport}{The variable importance metrics at each iteration, for each dataset.}
\item{allError}{The OOB model error for all variables at each iteration, for each dataset.}
\item{finalImps}{The final imputations for each dataset.}
\item{finalImport}{The final variable importance metrics for each dataset.}
\item{finalError}{The final model error for each variable in every dataset.}
\item{imputationTime}{The total time in seconds taken to create the imputations for the 
  specified datasets and iterations. Does not include any setup time.}
}
\description{
Performs Multiple Imputation by Chained Equations (MICE).
Creates a miceDefs object, which contains information about the imputation process.
}
\examples{
# Using Mice to create 5 imputed datasets
data(iris)

ampIris <- amputeData(iris)

miceObj <- miceRanger(
  ampIris
  , m = 2
  , maxiter = 2
  , verbose=FALSE
  , num.threads = 1
  , num.trees=5
)

\donttest{
# Run in parallel
data(iris)
ampIris <- amputeData(iris)

library(doParallel)
cl <- makeCluster(2)
registerDoParallel(cl)

# Perform mice 
parTime <- system.time(
  miceObjPar <- miceRanger(
    ampIris
    , m=2
    , maxiter = 2
    , parallel = TRUE
    , verbose = FALSE
  )
)
stopCluster(cl)
registerDoSEQ()
}
}
