% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/impute.R
\name{impute}
\alias{impute}
\title{Impute New Data With Existing Models}
\usage{
impute(
  data,
  miceObj,
  datasets = 1:miceObj$callParams$m,
  iterations = miceObj$callParams$maxiter,
  verbose = TRUE
)
}
\arguments{
\item{data}{The data to be imputed. Must have all columns used in the imputation of miceDefs.}

\item{miceObj}{A miceDefs object created by \code{miceRanger()}.}

\item{datasets}{A numeric vector specifying the datasets with which to impute \code{data}.
See details for more information.}

\item{iterations}{The number of iterations to run. 
By default, the same as the number of iterations currently in \code{miceObj}.}

\item{verbose}{should progress be printed?}
}
\value{
an object of class impDefs, which contains information about the imputation process.
}
\description{
Impute data using the information from an existing \code{miceDefs} object.
}
\details{
This capability is experimental, but works well in 
\href{https://github.com/FarrellDay/miceRanger/tree/master/benchmarks}{benchmarking}. 
The original data and random forests (if returnModels = TRUE) are returned when \code{miceRanger} 
is called. These models can be recycled to impute a new dataset in the same fashion as \code{miceRanger},
by imputing each variable over a series of iterations. Each dataset created in \code{miceObj} 
can be thought of as a different imputation mechanism, with different initialized values
and a different associated random forests. Therefore, it is necessary to choose the datasets
which will be used to impute the data. When mean matching a numeric variable, the candidate 
values are drawn from the original data passed to \code{miceRanger}, not the \code{data} passed 
to this function.
}
\examples{
ampDat <- amputeData(iris)
miceObj <- miceRanger(ampDat,1,1,returnModels=TRUE,verbose=FALSE)

newDat <- amputeData(iris)
newImps <- impute(newDat,miceObj)
}
