% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cmpoutput.R
\name{plot.assumptions_cmpoutput}
\alias{plot.assumptions_cmpoutput}
\title{Plot \emph{p}-values for testing the assumptions of the parametric tests used
in output comparison}
\usage{
\method{plot}{assumptions_cmpoutput}(x, ...)
}
\arguments{
\item{x}{Objects of class \code{assumptions_cmpoutput}.}

\item{...}{Extra options passed to \code{\link[graphics]{plot.default}}.}
}
\value{
None.
}
\description{
Plot method for objects of class \code{assumptions_cmpoutput}
containing \emph{p}-values produced by testing the assumptions of the
parametric tests used for comparing an output.
}
\details{
Several bar plots are presented, showing the \emph{p}-values yielded by the
Shapiro-Wilk (\code{\link[stats]{shapiro.test}}) and Royston tests
(\code{\link[MVN]{roystonTest}}) for univariate and multivariate normality,
respectively, and for the Bartlett (\code{\link[stats]{bartlett.test}}) and
Box's M (\code{\link[biotools]{boxM}}) for testing homogeneity of variances
and of covariance matrices, respectively. The following bar plots are shown:

\itemize{
 \item One bar plot for the \emph{p}-values of the Bartlett test, one bar
       (\emph{p}-value) per individual principal component.
 \item \emph{s} bar plots for \emph{p}-values of the Shapiro-Wilk test, where
       \emph{s} is the number of groups being compared. Individual bars in
       each plot are associated with a principal component.
 \item \emph{t} bar plot for the \emph{p}-values of the Royston test with
       \emph{s} bars each, where \emph{t} is the number of unique MANOVA
       tests performed (one per requested explained variances) and \emph{s}
       is the number of groups being compared. These plots will not show if
       there is only one principal component being considered.
 \item One plot for the \emph{p}-values of the Box's M test, one bar
       (\emph{p}-value) per unique MANOVA tests performed  (one per requested
       explained variances).
}
}
\examples{

# Create a cmpoutput object from the provided datasets
cmp <- cmpoutput("All", 0.9, pphpc_ok$data[["All"]], pphpc_ok$obs_lvls)

# Display a bar plot with the p-values of the assumptions for the parametric
# tests performed in cmp
plot(assumptions(cmp))

}

