% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/util.R
\name{pvalcol}
\alias{pvalcol}
\title{Associate colors to \emph{p}-values}
\usage{
pvalcol(pvals, col, pvlims = c(0.05, 0.01))
}
\arguments{
\item{pvals}{Vector of \emph{p}-values to which associate colors.}

\item{col}{Colors Vector of colors to associate with the \emph{p}-values
given in \code{pvals} according to the limits specified in \code{pvlims}.}

\item{pvlims}{Vector of \emph{p}-value upper limits, first value should be 1.}
}
\value{
A vector of colors associated with \emph{p}-values given in
\code{pvals}.
}
\description{
Associate colors to \emph{p}-values according to their value.
}
\examples{
micompr:::pvalcol(c(0.06, 0.9, 0.0001, 0.3, 0.2, 0.02),
                  c("darkgreen", "yellow", "red"))
# [1] "darkgreen" "darkgreen" "red"       "darkgreen" "darkgreen" "yellow"

}
\keyword{internal}
