#' Checks whether the solution generated by the ODE solver contains negative values
#' @param stateVar Name of state variable
#' @param out output from microPopModel
#' @param tol tolerance 

checkSolution=function(stateVar,out,tol=-1e-1){

  for (v in 2:length(stateVar)){

    var=stateVar[v]
    if (any(out[,var] < tol)){print(paste('MICROPOP WARNING: There are negative values for',var))}

  }
}
