% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.R
\name{plotbar}
\alias{plotbar}
\title{plot bar for relative abundance for bacteria}
\usage{
plotbar(
  physeq,
  level = "Phylum",
  color = NULL,
  group = NULL,
  top = 5,
  fontsize.x = 5,
  fontsize.y = 12
)
}
\arguments{
\item{physeq}{A \code{phyloseq} object containing merged information of abundance,
taxonomic assignment, sample data including the measured variables and categorical information
of the samples, and / or phylogenetic tree if available.}

\item{level}{the level to plot}

\item{color}{A vector of character use specifying the color}

\item{group}{group (Optional). A character string specifying the name of a categorical variable containing  grouping information.}

\item{top}{the number of most abundance bacteria to display}

\item{fontsize.x}{the size of x axis label}

\item{fontsize.y}{the size of y axis label}
}
\value{
Returns a ggplot object. This can further be manipulated as preferred by user.
}
\description{
plot bar for relative abundance for bacteria
}
\examples{
\donttest{
data("Physeq")
phy<-normalize(physeq)
plotbar(phy,level="Phylum")
}
}
\author{
Kai Guo
}
