% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.R
\name{plotalpha}
\alias{plotalpha}
\title{plot alpha diversity}
\usage{
plotalpha(
  physeq,
  group,
  method = c("Observed", "Simpson", "Shannon"),
  color = NULL,
  geom = "boxplot",
  pvalue = 0.05,
  padj = NULL,
  sig.only = TRUE,
  wilcox = FALSE,
  show.number = FALSE
)
}
\arguments{
\item{physeq}{A \code{phyloseq} object containing merged information of abundance,
taxonomic assignment, sample data including the measured variables and categorical information
of the samples, and / or phylogenetic tree if available.}

\item{group}{group (Required). A character string specifying the name of a categorical variable containing  grouping information.}

\item{method}{A list of character strings specifying \code{method} to be used to calculate for alpha diversity
in the data. Available methods are: "Observed","Chao1","ACE","Richness", "Fisher", "Simpson", "Shannon", "Evenness","InvSimpson".}

\item{color}{A vector of character use specifying the color}

\item{geom}{different geom to display("boxplot","violin","dotplot")}

\item{pvalue}{pvalue threshold for significant dispersion results}

\item{padj}{adjust p value threshold for significant dispersion results}

\item{sig.only}{display the significant comparsion only(TRUE/ FALSE)}

\item{wilcox}{use wilcoxon test or not}

\item{show.number}{to show the pvalue instead of significant symbol(TRUE/FALSE)}
}
\value{
Returns a ggplot object. This can further be manipulated as preferred by user.
}
\description{
plot alpha diversity
}
\examples{
{
data("Physeq")
plotalpha(physeq,group="SampleType")
}
}
\author{
Kai Guo
}
