% File micromapST\man\micromapST-package.Rd
\name{micromapST-package}
\alias{micromapST-package}
\docType{package}
\title{A graphics package to create linked micromaps for the U.S. States}
\description{
 The micromapST package provides a means of creating multiple column
 graphics representing data from each US state and the District of Columbia. Columns
 may contain a US map, state ID and several types of charts/glyphs. Each state's graphical
 element is linked to a small map by means of color.
}
\details{
    \tabular{ll}{
      Package:  \tab micromapST\cr
      Type:     \tab Package\cr
      Version:  \tab 1.0.3\cr
      Date:     \tab 2014-03-07\cr
      License:  \tab GPL-2\cr
      LazyLoad: \tab yes\cr
    } 
Linked micromap plots link statistical graphs to an organized set of small maps, thus
adding geographical context to the graphs.  This version creates a linked micromap plot
for the 50 U.S. states and the District of Columbia that fits on a single 8.5" by 11"
page in portrait orientation. States are grouped into panels of 5 states each based on
the sort variable, with the median-valued state set off in a separate panel in the
middle of the page. For each group of states, there is a row of panels comprised of a
U.S. map, a list of the state names, and one or more statistical graphics. The order of
these panels is specified by the user. The statistical graphics implemented in this
version are plots of dots, dots with confidence intervals, horizontal bars, arrows,
time series with or without confidence bands, horizontal stacked (segmented) bar charts,
scatter plots and boxplots.

The U.S. map of states is a generalized boundary map, based on Mark Monmonier's
"visibility" map. This map is simplified to maximize the color areas shown for each
state and to minimize the length of the boundary lines while still allowing
identification of each state.

The sort order of the rows (states) is based one of the statistical data columns as specified by
the user.  Correlation between multiple statistical columns can be judged visually by
comparing the pattern of one column's values from top to bottom of the page with that
of the sorted column.  Spatial clusters of states with similar values of the sorting
variable can be identified on the 10 small maps that are linked to the graphics by
color.

A state linked micromap plot is generated by 4 steps:

  \preformatted{

  # load the package  

  library(micromapST)

  # read, create or collect your data into a data.frame = stateFrame 

  stateFrame <- data.frame(a row per state and DC (51), column per 
                          variable to be ploted, rownames set to 
                          the state names or abbreviations)

  # now set up a data frame that defines the labels, 
  #       panel and page layout

  panelDesc<-data.frame(...)

  # specify the data source, panelDesc, sorting variable and 
  #       order, and call the stateMicromap function

  micromapST(stateFrame,panelDesc, title=c('title1','title2'), details=list(options=values))

  }

The package contains a set of examples of how to produce linked state micromaps.
The datasets used in each example are provided to help you learn how to use micromapST.
}  

\author{
Daniel B. Carr \email{dcarr@gmu.edu}, with contributions from Jim Pearson and Linda Pickle\cr
Maintainer: Jim Pearson \email{jpearson@statnetconsulting.com}\cr 
Package compiled by Jim Pearson \email{jpearson@statnetconsulting.com}
}

\references{
Daniel B. Carr and Linda Williams Pickle, Visualizing Data Patterns with Micromaps, CRC
Press, 2010
}

\note{
In the examples in the package, the output is first directed to the screen and 
then to a PDF (or SVG or PNG or JPEG or TIFF) file. 
The \code{windows(7.5,10,xpinch=75,ypinch=75,point=9)} command sets the scale 
of the graphics window to display the resulting plot properly on the screen.  
You may need to modify or delete this line for
proper display depending on your screen resolution.  Each file command should also use the a 
width of 7.5 inches and height of 10 inches.
}
